/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.net.ConnectException;

@Provider
@Singleton
public class SearchRuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    public Response toResponse(RuntimeException exception) {
        for (Throwable thrown = exception; thrown != null; thrown = thrown.getCause()) {
            if (!(thrown instanceof ConnectException)) continue;
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return ResponseFactory.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestErrors("An error occurred while processing the request. Check the server logs for more information.")).type("application/json;charset=UTF-8").build();
    }
}

