/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest.aggregation;

import jakarta.annotation.Nonnull;
import java.util.Objects;

public class Aggregation {
    private final int count;
    private final String type;

    private Aggregation(Builder builder) {
        this.type = builder.type;
        this.count = builder.count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getCount() {
        return this.count;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private int count;
        private String type;

        private Builder() {
        }

        public Aggregation build() {
            return new Aggregation(this);
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder type(@Nonnull String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }
    }
}

