/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest.convert;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.search.DetailedRepository;
import com.atlassian.bitbucket.internal.search.search.rest.RestCodeSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestDetailedRepository;
import com.atlassian.bitbucket.internal.search.search.rest.RestDetailedRepositoryPage;
import com.atlassian.bitbucket.internal.search.search.rest.RestFileHit;
import com.atlassian.bitbucket.internal.search.search.rest.RestHitContext;
import com.atlassian.bitbucket.internal.search.search.rest.RestProjectSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestQuery;
import com.atlassian.bitbucket.internal.search.search.rest.RestRepositorySearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestResultCategory;
import com.atlassian.bitbucket.internal.search.search.rest.RestResultScope;
import com.atlassian.bitbucket.internal.search.search.rest.RestSearchResult;
import com.atlassian.bitbucket.internal.search.search.rest.RestSegment;
import com.atlassian.bitbucket.internal.search.search.result.DetailedRepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.result.FileSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import com.atlassian.bitbucket.internal.search.search.result.ProjectSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.ResultScope;
import com.atlassian.bitbucket.internal.search.search.result.SearchResult;
import com.atlassian.bitbucket.internal.search.search.result.Segment;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RestConverter {
    private final AvatarEnricher avatarEnricher;
    private final I18nService i18nService;

    public RestConverter(AvatarEnricher avatarEnricher, I18nService i18nService) {
        this.avatarEnricher = avatarEnricher;
        this.i18nService = i18nService;
    }

    public RestSearchResult convert(SearchResult searchResult, ContainerRequestContext containerRequestContext) {
        Optional<FileSearchResult> fileSearchResult = searchResult.getFileSearchResult();
        Optional<ProjectSearchResult> projectSearchResult = searchResult.getProjectSearchResult();
        Optional<RepositorySearchResult> repositorySearchResult = searchResult.getRepositorySearchResult();
        RestSearchResult.Builder resultBuilder = RestSearchResult.builder();
        fileSearchResult.ifPresent(fsr -> resultBuilder.codeSearchResults(((RestCodeSearchResults.Builder)RestCodeSearchResults.builder().resultCategory(RestResultCategory.PRIMARY)).fileSearchResultsData((FileSearchResult)fsr).fileHits(this.buildHits((FileSearchResult)fsr, containerRequestContext)).build()));
        projectSearchResult.ifPresent(rsr -> resultBuilder.projectSearchResults(((RestProjectSearchResults.Builder)RestProjectSearchResults.builder().resultCategory(RestResultCategory.SECONDARY)).projectSearchResultsData((ProjectSearchResult)rsr).projectSearchResultsRepositories(this.buildProjectHits((ProjectSearchResult)rsr, containerRequestContext)).build()));
        repositorySearchResult.ifPresent(rsr -> resultBuilder.repositorySearchResults(((RestRepositorySearchResults.Builder)RestRepositorySearchResults.builder().resultCategory(RestResultCategory.SECONDARY)).repositorySearchResultsData((RepositorySearchResult)rsr).repositorySearchResultsRepositories(this.buildRepositoryHits((RepositorySearchResult)rsr, containerRequestContext)).build()));
        resultBuilder.scope(this.buildScope(searchResult.getResultScope(), containerRequestContext));
        searchResult.getQuery().ifPresent(query -> resultBuilder.query(RestQuery.builder(query).build()));
        return resultBuilder.build();
    }

    public RestPage<RestRepository> convert(RepositorySearchResult repositorySearchResult, PageRequest pageRequest, ContainerRequestContext containerRequestContext) {
        return new RestPage(PageUtils.createPage(this.buildRepositoryHits(repositorySearchResult, containerRequestContext), (boolean)repositorySearchResult.isLastPage(), (PageRequest)pageRequest));
    }

    public RestPage<RestDetailedRepository> convert(DetailedRepositorySearchResult repositorySearchResult, PageRequest pageRequest, ContainerRequestContext containerRequestContext) {
        return new RestDetailedRepositoryPage((Page<RestDetailedRepository>)PageUtils.createPage(this.buildDetailedRespositoryHits(repositorySearchResult, containerRequestContext), (boolean)repositorySearchResult.isLastPage(), (PageRequest)pageRequest), repositorySearchResult.getTotalHitCount());
    }

    List<RestHitContext> buildHitContexts(FileHit hit) {
        return hit.getHitContexts().stream().map(ctx -> RestHitContext.builder().context((HitContext)ctx).build()).collect(Collectors.toList());
    }

    List<RestFileHit> buildHits(FileSearchResult fsr, ContainerRequestContext containerRequestContext) {
        return fsr.getFileHits().stream().map(hit -> this.buildRestFileHit((FileHit)hit, containerRequestContext)).collect(Collectors.toList());
    }

    List<RestProject> buildProjectHits(ProjectSearchResult psr, ContainerRequestContext containerRequestContext) {
        return psr.getProjects().stream().map(project -> this.buildRestProject((Project)project, containerRequestContext)).collect(Collectors.toList());
    }

    List<RestRepository> buildRepositoryHits(RepositorySearchResult rsr, ContainerRequestContext containerRequestContext) {
        return rsr.getRepositories().stream().map(repository -> this.buildRestRepository((Repository)repository, containerRequestContext)).collect(Collectors.toList());
    }

    List<RestDetailedRepository> buildDetailedRespositoryHits(DetailedRepositorySearchResult drsr, ContainerRequestContext containerRequestContext) {
        return drsr.getDetailedRepositories().stream().map(detailedRepository -> this.buildRestDetailedRepository((DetailedRepository)detailedRepository, containerRequestContext)).collect(Collectors.toList());
    }

    RestFileHit buildRestFileHit(FileHit hit, ContainerRequestContext containerRequestContext) {
        List<RestHitContext> hitContexts = this.buildHitContexts(hit);
        int hitCount = hitContexts.stream().mapToInt(RestHitContext::getHitCount).sum();
        return RestFileHit.builder().hit(hit).repository(this.buildRestRepository(hit.getRepository(), containerRequestContext)).hitContexts(hitContexts).pathMatches((List)hit.getPathMatches().stream().map(this::buildRestSegment).collect(MoreCollectors.toImmutableList())).hitCount(hitCount).build();
    }

    RestProject buildRestProject(Project project, ContainerRequestContext containerRequestContext) {
        RestProject restProject = new RestProject(project);
        this.avatarEnricher.enrich((Object)restProject, AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)containerRequestContext, (I18nService)this.i18nService));
        return restProject;
    }

    Optional<RestProject> buildRestProject(Optional<Project> maybeProject, ContainerRequestContext containerRequestContext) {
        return maybeProject.map(project -> this.buildRestProject((Project)project, containerRequestContext));
    }

    RestRepository buildRestRepository(Repository repository, ContainerRequestContext containerRequestContext) {
        RestRepository restRepository = new RestRepository(repository);
        this.avatarEnricher.enrich((Object)restRepository.getProject(), AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)containerRequestContext, (I18nService)this.i18nService));
        return restRepository;
    }

    RestDetailedRepository buildRestDetailedRepository(DetailedRepository repository, ContainerRequestContext containerRequestContext) {
        RestDetailedRepository restDetailedRepository = new RestDetailedRepository(repository);
        this.avatarEnricher.enrich((Object)restDetailedRepository.getRepository().getProject(), AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)containerRequestContext, (I18nService)this.i18nService));
        return restDetailedRepository;
    }

    Optional<RestRepository> buildRestRepository(Optional<Repository> maybeRepository, ContainerRequestContext containerRequestContext) {
        return maybeRepository.map(repository -> this.buildRestRepository((Repository)repository, containerRequestContext));
    }

    RestResultScope buildScope(ResultScope resultScope, ContainerRequestContext containerRequestContext) {
        return RestResultScope.builder().scopeType(resultScope.getType()).project(this.buildRestProject(resultScope.getProject(), containerRequestContext)).repository(this.buildRestRepository(resultScope.getRepository(), containerRequestContext)).build();
    }

    private RestSegment buildRestSegment(Segment segment) {
        return RestSegment.builder().text(segment.getText()).isMatching(segment.isMatching()).build();
    }
}

