/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest.convert;

import com.atlassian.bitbucket.internal.search.SearchException;
import com.atlassian.bitbucket.internal.search.search.request.DefaultSearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.DefaultSearchRequest;
import com.atlassian.bitbucket.internal.search.search.request.SearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.SearchRequest;
import com.atlassian.bitbucket.internal.search.search.rest.RestSearchRequest;
import io.atlassian.fugue.Either;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public class ToModel
implements Function<RestSearchRequest, Either<SearchException, SearchRequest>> {
    public static final ToModel INSTANCE = new ToModel();
    private static final int MAX_PAGE_SIZE = Integer.getInteger("index.codesearch.resultWindow.max", 1000);

    private ToModel() {
    }

    @Override
    public Either<SearchException, SearchRequest> apply(RestSearchRequest searchRequest) {
        if (searchRequest == null) {
            return Either.left((Object)new SearchException("Request must not be empty."));
        }
        if (searchRequest.getQuery() == null) {
            return Either.left((Object)new SearchException("Query must not be empty."));
        }
        if (searchRequest.getEntities() == null) {
            return Either.left((Object)new SearchException("Entities must not be empty."));
        }
        Map<String, RestSearchRequest.PagingInfo> entities = searchRequest.getEntities();
        RestSearchRequest.Limits limits = searchRequest.getLimits();
        if (entities.size() > 1) {
            return Either.left((Object)new SearchException("Multiple entity searches are currently unsupported"));
        }
        DefaultSearchRequest.Builder searchRequestBuilder = (DefaultSearchRequest.Builder)((Object)new DefaultSearchRequest.Builder().rawSearchQuery(searchRequest.getQuery()));
        entities.forEach((key, value) -> searchRequestBuilder.searchPagingInfo(SearchRequest.SearchRequestType.valueOf(key.toUpperCase(Locale.US)), this.computeSearchPagingInfo((RestSearchRequest.PagingInfo)value, limits)));
        return Either.right((Object)searchRequestBuilder.build());
    }

    private SearchPagingInfo computeSearchPagingInfo(RestSearchRequest.PagingInfo pagingInfo, RestSearchRequest.Limits limits) {
        DefaultSearchPagingInfo.Builder builder = DefaultSearchPagingInfo.builder();
        if (pagingInfo != null) {
            builder.offset(pagingInfo.getStart());
        }
        IntStream.of(Optional.ofNullable(pagingInfo).map(RestSearchRequest.PagingInfo::getLimit).orElse(0), Optional.ofNullable(limits).map(RestSearchRequest.Limits::getPrimary).orElse(0)).filter(n -> n > 0).map(n -> Math.min(n, MAX_PAGE_SIZE)).min().ifPresent(builder::pageSize);
        return builder.build();
    }
}

