/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.AbstractPageable;
import com.atlassian.bitbucket.internal.search.search.DetailedRepository;
import com.atlassian.bitbucket.internal.search.search.result.DetailedRepositorySearchResult;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultDetailedRepositorySearchResult
extends AbstractPageable<Builder>
implements DetailedRepositorySearchResult {
    private final Collection<DetailedRepository> detailedRepositories;
    private final long totalHitCount;

    protected DefaultDetailedRepositorySearchResult(Builder builder) {
        super(builder);
        this.detailedRepositories = builder.detailedRepositories;
        this.totalHitCount = builder.totalHitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Collection<DetailedRepository> getDetailedRepositories() {
        return Collections.unmodifiableCollection(this.detailedRepositories);
    }

    @Override
    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public String toString() {
        return "{totalHitCount: " + this.totalHitCount + ", repository IDs: [" + String.valueOf(this.detailedRepositories.stream().map(detailedRepository -> detailedRepository.getRepository().getId()).collect(Collectors.toSet())) + "]}";
    }

    public static class Builder
    extends AbstractPageable.Builder<Builder> {
        private Collection<DetailedRepository> detailedRepositories = Collections.emptyList();
        private long totalHitCount;

        private Builder() {
        }

        public DefaultDetailedRepositorySearchResult build() {
            return new DefaultDetailedRepositorySearchResult(this.self());
        }

        public Builder detailedRepositories(@Nonnull Collection<DetailedRepository> detailedRepositories) {
            this.detailedRepositories = Collections.unmodifiableCollection(Objects.requireNonNull(detailedRepositories, "detailedRepositories"));
            return this.self();
        }

        public Builder totalHitCount(long totalHitCount) {
            this.totalHitCount = totalHitCount;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

