/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import com.atlassian.bitbucket.internal.search.search.result.Segment;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultFileHit
implements FileHit {
    private final List<HitContext> hitContexts;
    private final String path;
    private final List<Segment> pathMatches;
    private final Repository repository;

    private DefaultFileHit(Builder builder) {
        this.path = builder.path;
        this.pathMatches = ImmutableList.copyOf(builder.pathMatches);
        this.repository = builder.repository;
        this.hitContexts = ImmutableList.copyOf(builder.hitContexts);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public List<HitContext> getHitContexts() {
        return this.hitContexts;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public List<Segment> getPathMatches() {
        return this.pathMatches;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public String toString() {
        return "{path: " + this.path + ", repository: " + String.valueOf(this.repository) + ", hitContexts: " + String.valueOf(this.hitContexts) + "}";
    }

    public static class Builder {
        private List<HitContext> hitContexts = new ArrayList<HitContext>();
        private String path;
        private List<Segment> pathMatches = new ArrayList<Segment>();
        private Repository repository;

        public DefaultFileHit build() {
            return new DefaultFileHit(this);
        }

        public Builder hitContexts(@Nonnull Iterable<HitContext> hitContexts) {
            Iterables.addAll(this.hitContexts, Objects.requireNonNull(hitContexts, "hitContexts"));
            return this;
        }

        public Builder pathMatches(@Nonnull Iterable<Segment> pathMatches) {
            Iterables.addAll(this.pathMatches, Objects.requireNonNull(pathMatches, "pathMatches"));
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }
    }
}

