/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.AbstractPageable;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.result.FileSearchResult;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class DefaultFileSearchResult
extends AbstractPageable<Builder>
implements FileSearchResult {
    private final Collection<FileHit> fileHits;
    private final long totalHitCount;

    private DefaultFileSearchResult(Builder builder) {
        super(builder);
        this.fileHits = builder.fileHits;
        this.totalHitCount = builder.totalHitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Collection<FileHit> getFileHits() {
        return Collections.unmodifiableCollection(this.fileHits);
    }

    @Override
    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public String toString() {
        return "{totalHitCount: " + this.totalHitCount + ", fileHits: [" + String.valueOf(this.fileHits) + "]}";
    }

    public static class Builder
    extends AbstractPageable.Builder<Builder> {
        private Collection<FileHit> fileHits = Collections.emptyList();
        private long totalHitCount;

        private Builder() {
        }

        public DefaultFileSearchResult build() {
            return new DefaultFileSearchResult(this.self());
        }

        public Builder fileHits(@Nonnull Collection<FileHit> fileHits) {
            this.fileHits = Objects.requireNonNull(fileHits, "fileHits");
            return this.self();
        }

        public Builder totalHitCount(long totalHitCount) {
            this.totalHitCount = totalHitCount;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

