/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultHitContext
implements HitContext {
    public static final HitContext EMPTY = DefaultHitContext.builder().build();
    private final int firstLineNumber;
    private final int hitCount;
    private final List<String> lines;

    private DefaultHitContext(Builder builder) {
        this.firstLineNumber = builder.firstLineNumber;
        this.lines = builder.lines;
        this.hitCount = builder.hitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int getFirstLineNumber() {
        return this.firstLineNumber;
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    @Nonnull
    public List<String> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public String toString() {
        return "HitContext{firstLineNumber=" + this.firstLineNumber + ", lines=" + String.valueOf(this.lines) + ", hitCount=" + this.hitCount + "}";
    }

    public static class Builder {
        private int firstLineNumber;
        private int hitCount;
        private List<String> lines = Collections.emptyList();

        private Builder() {
        }

        public HitContext build() {
            return new DefaultHitContext(this);
        }

        public Builder firstLineNumber(int firstLineNumber) {
            this.firstLineNumber = firstLineNumber;
            return this;
        }

        public Builder hitCount(int hitCount) {
            this.hitCount = hitCount;
            return this;
        }

        public Builder lines(@Nonnull List<String> lines) {
            this.lines = Objects.requireNonNull(lines, "lines");
            return this;
        }
    }
}

