/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.AbstractPageable;
import com.atlassian.bitbucket.internal.search.search.result.ProjectSearchResult;
import com.atlassian.bitbucket.project.Project;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class DefaultProjectSearchResult
extends AbstractPageable<Builder>
implements ProjectSearchResult {
    private final Collection<Project> projects;
    private final long totalHitCount;

    private DefaultProjectSearchResult(@Nonnull Builder builder) {
        super(Objects.requireNonNull(builder, "builder"));
        this.projects = builder.projects;
        this.totalHitCount = builder.totalHitCount;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Collection<Project> getProjects() {
        return Collections.unmodifiableCollection(this.projects);
    }

    @Override
    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    @Nonnull
    public String toString() {
        return "{totalHitCount: " + this.totalHitCount + ", projects: [" + String.valueOf(this.projects) + "]}";
    }

    public static class Builder
    extends AbstractPageable.Builder<Builder> {
        private Collection<Project> projects = Collections.emptyList();
        private long totalHitCount;

        private Builder() {
        }

        @Nonnull
        public DefaultProjectSearchResult build() {
            return new DefaultProjectSearchResult(this.self());
        }

        @Nonnull
        public Builder projects(@Nonnull Collection<Project> projects) {
            this.projects = Collections.unmodifiableCollection(Objects.requireNonNull(projects, "projects"));
            return this.self();
        }

        @Nonnull
        public Builder totalHitCount(long totalHitCount) {
            this.totalHitCount = totalHitCount;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

