/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.AbstractPageable;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultRepositorySearchResult
extends AbstractPageable<Builder>
implements RepositorySearchResult {
    private final Collection<Repository> repositories;
    private final long totalHitCount;

    private DefaultRepositorySearchResult(Builder builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.totalHitCount = builder.totalHitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    @Override
    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public String toString() {
        return "{totalHitCount: " + this.totalHitCount + ", repository IDs: [" + String.valueOf(this.repositories.stream().map(Repository::getId).collect(Collectors.toSet())) + "]}";
    }

    public static class Builder
    extends AbstractPageable.Builder<Builder> {
        private Collection<Repository> repositories = Collections.emptyList();
        private long totalHitCount;

        private Builder() {
        }

        public DefaultRepositorySearchResult build() {
            return new DefaultRepositorySearchResult(this.self());
        }

        public Builder repositories(@Nonnull Collection<Repository> repositories) {
            this.repositories = Collections.unmodifiableCollection(Objects.requireNonNull(repositories, "repositories"));
            return this.self();
        }

        public Builder totalHitCount(long totalHitCount) {
            this.totalHitCount = totalHitCount;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

