/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.result.FileSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.ProjectSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.ResultScope;
import com.atlassian.bitbucket.internal.search.search.result.SearchResult;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class DefaultSearchResult
implements SearchResult {
    private final FileSearchResult fileSearchResult;
    private final ProjectSearchResult projectSearchResult;
    private final Query query;
    private final RepositorySearchResult repositorySearchResult;
    private final ResultScope resultScope;

    private DefaultSearchResult(Builder builder) {
        this.fileSearchResult = builder.fileSearchResult;
        this.projectSearchResult = builder.projectSearchResult;
        this.repositorySearchResult = builder.repositorySearchResult;
        this.resultScope = builder.resultScope;
        this.query = builder.query;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Optional<FileSearchResult> getFileSearchResult() {
        return Optional.ofNullable(this.fileSearchResult);
    }

    @Override
    @Nonnull
    public Optional<ProjectSearchResult> getProjectSearchResult() {
        return Optional.ofNullable(this.projectSearchResult);
    }

    @Override
    @Nonnull
    public Optional<Query> getQuery() {
        return Optional.ofNullable(this.query);
    }

    @Override
    @Nonnull
    public Optional<RepositorySearchResult> getRepositorySearchResult() {
        return Optional.ofNullable(this.repositorySearchResult);
    }

    @Override
    public ResultScope getResultScope() {
        return this.resultScope;
    }

    public String toString() {
        return "DefaultSearchResult{fileSearchResult=" + String.valueOf(this.fileSearchResult) + ", projectSearchResult=" + String.valueOf(this.projectSearchResult) + ", repositorySearchResult=" + String.valueOf(this.repositorySearchResult) + "}";
    }

    public static class Builder {
        private FileSearchResult fileSearchResult;
        private ProjectSearchResult projectSearchResult;
        private Query query;
        private RepositorySearchResult repositorySearchResult;
        private ResultScope resultScope;

        private Builder() {
        }

        @Nonnull
        public DefaultSearchResult build() {
            return new DefaultSearchResult(this);
        }

        @Nonnull
        public Builder fileSearchResult(@Nonnull FileSearchResult fileSearchResult) {
            this.fileSearchResult = Objects.requireNonNull(fileSearchResult, "fileSearchResult");
            return this;
        }

        @Nonnull
        public Builder projectSearchResult(@Nonnull ProjectSearchResult projectSearchResult) {
            this.projectSearchResult = Objects.requireNonNull(projectSearchResult, "projectSearchResult");
            return this;
        }

        @Nonnull
        public Builder query(@Nonnull Optional<Query> query) {
            this.query = Objects.requireNonNull(query, "query").orElse(null);
            return this;
        }

        @Nonnull
        public Builder repositorySearchResult(@Nonnull RepositorySearchResult repositorySearchResult) {
            this.repositorySearchResult = Objects.requireNonNull(repositorySearchResult, "repositorySearchResult");
            return this;
        }

        @Nonnull
        public Builder scope(@Nonnull ResultScope resultScope) {
            this.resultScope = Objects.requireNonNull(resultScope, "resultScope");
            return this;
        }
    }
}

