/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.result;

import com.atlassian.bitbucket.internal.search.search.result.Segment;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultSegment
implements Segment {
    private final String text;
    private final boolean matching;

    private DefaultSegment(Builder builder) {
        this.text = builder.text;
        this.matching = builder.matching;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Segment matching(String text) {
        return DefaultSegment.builder().text(text).matching(true).build();
    }

    public static Segment nonMatching(String text) {
        return DefaultSegment.builder().text(text).matching(false).build();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isMatching() {
        return this.matching;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSegment that = (DefaultSegment)o;
        return this.matching == that.matching && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.matching);
    }

    public String toString() {
        return "DefaultSegment{text='" + this.text + "', matching=" + this.matching + "}";
    }

    public static class Builder {
        private String text;
        private boolean matching;

        public DefaultSegment build() {
            return new DefaultSegment(this);
        }

        public Builder text(@Nonnull String text) {
            this.text = Objects.requireNonNull(text, "text");
            return this;
        }

        public Builder matching(boolean matching) {
            this.matching = matching;
            return this;
        }
    }
}

