/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.internal.search.search.result.ResultScope;
import com.atlassian.bitbucket.internal.search.search.result.ResultScopeType;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class DefaultResultScope
implements ResultScope {
    private static final ResultScope GLOBAL = new DefaultResultScope(null, null);
    private final Project project;
    private final Repository repository;
    private final ResultScopeType type;

    private DefaultResultScope(@Nullable Project project, @Nullable Repository repository) {
        this.project = project;
        this.repository = repository;
        this.type = project != null ? ResultScopeType.PROJECT : (repository != null ? ResultScopeType.REPOSITORY : ResultScopeType.GLOBAL);
    }

    public static ResultScope global() {
        return GLOBAL;
    }

    public static ResultScope project(@Nonnull Project project) {
        return new DefaultResultScope(Objects.requireNonNull(project, "project"), null);
    }

    public static ResultScope repository(@Nonnull Repository repository) {
        return new DefaultResultScope(null, Objects.requireNonNull(repository, "repository"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResultScope that = (DefaultResultScope)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.repository, that.repository) && this.type == that.type;
    }

    @Override
    @Nonnull
    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    @Override
    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Override
    @Nonnull
    public ResultScopeType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.project, this.repository, this.type});
    }
}

