/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.internal.search.search.result.ResultScope;
import com.atlassian.bitbucket.internal.search.search.scope.DefaultResultScope;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;

public class DefaultScope
implements Scope {
    private static final Scope EVERYTHING = new Builder(true).build();
    private static final Scope NOTHING = new Builder(false).build();
    private final boolean isConsistent;
    private final Collection<Project> projects;
    private final Collection<Repository> repositories;
    private final ResultScope resultScope;

    private DefaultScope(Builder builder) {
        this.isConsistent = builder.isConsistent;
        this.projects = builder.projects;
        this.repositories = builder.repositories;
        this.resultScope = builder.resultScope;
    }

    public static Builder builder() {
        return new Builder(true);
    }

    public static Scope everything() {
        return EVERYTHING;
    }

    public static Scope nothing() {
        return NOTHING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultScope that = (DefaultScope)o;
        return this.isConsistent == that.isConsistent && Objects.equals(this.projects, that.projects) && Objects.equals(this.repositories, that.repositories) && Objects.equals(this.resultScope, that.resultScope);
    }

    @Override
    @Nonnull
    public Collection<Project> getProjects() {
        return Collections.unmodifiableCollection(this.projects);
    }

    @Override
    @Nonnull
    public Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    @Override
    @Nonnull
    public ResultScope getResultScope() {
        return this.resultScope;
    }

    public int hashCode() {
        return Objects.hash(this.isConsistent, this.projects, this.repositories, this.resultScope);
    }

    @Override
    public boolean isConsistent() {
        return this.isConsistent;
    }

    public static class Builder {
        private final boolean isConsistent;
        private final Collection<Project> projects = new HashSet<Project>();
        private final Collection<Repository> repositories = new HashSet<Repository>();
        private ResultScope resultScope = DefaultResultScope.global();

        public Builder(boolean isConsistent) {
            this.isConsistent = isConsistent;
        }

        public Scope build() {
            return new DefaultScope(this);
        }

        public Builder projects(@Nonnull Collection<Project> projects) {
            Objects.requireNonNull(projects, "projects");
            this.projects.addAll(projects);
            return this;
        }

        public Builder repositories(@Nonnull Collection<Repository> repositories) {
            Objects.requireNonNull(repositories, "repositories");
            this.repositories.addAll(repositories);
            return this;
        }

        public Builder resultScope(@Nonnull ResultScope resultScope) {
            this.resultScope = Objects.requireNonNull(resultScope, "resultScope");
            return this;
        }
    }
}

