/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import jakarta.annotation.Nonnull;
import java.util.Objects;

class ProjectAndRepository {
    private final String projectKey;
    private final String repositorySlug;

    private ProjectAndRepository(Builder builder) {
        this.projectKey = Objects.requireNonNull(builder.projectKey, "builder.projectKey");
        this.repositorySlug = Objects.requireNonNull(builder.repositorySlug, "builder.repositorySlug");
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAndRepository that = (ProjectAndRepository)o;
        return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.repositorySlug, that.repositorySlug);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.repositorySlug);
    }

    public static final class Builder {
        private String projectKey;
        private String repositorySlug;

        private Builder() {
        }

        @Nonnull
        public ProjectAndRepository build() {
            return new ProjectAndRepository(this);
        }

        @Nonnull
        public Builder projectKey(@Nonnull String projectKey) {
            this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
            return this;
        }

        @Nonnull
        public Builder repositorySlug(@Nonnull String repositorySlug) {
            this.repositorySlug = Objects.requireNonNull(repositorySlug, "repositorySlug");
            return this;
        }
    }
}

