/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.common.util.Optionals;
import com.atlassian.bitbucket.internal.search.search.convert.SearchProjectHit;
import com.atlassian.bitbucket.internal.search.search.convert.SearchRepositoryHit;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.scope.ProjectAndRepository;
import com.atlassian.bitbucket.internal.search.search.scope.ScopeResolvingQueryBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.search.SearchRequestBuilder;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class ProjectAndRepositoryFinder {
    private static final Logger log = LoggerFactory.getLogger(ProjectAndRepositoryFinder.class);
    private final SearchClient client;
    private final ProjectService projectService;
    private final ScopeResolvingQueryBuilder queryBuilder;
    private final RepositoryService repositoryService;

    @Autowired
    public ProjectAndRepositoryFinder(SearchClient client, ProjectService projectService, RepositoryService repositoryService) {
        this.client = client;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.queryBuilder = new ScopeResolvingQueryBuilder();
    }

    @Nonnull
    public Observable<Project> findProjects(@Nonnull List<String> projectKeys) {
        if (projectKeys.isEmpty()) {
            return Observable.empty();
        }
        Observable<SearchResponse> projectsSearch = this.searchFor(ProjectMapping.type(), this.queryBuilder.queryForProjectsByKey(projectKeys), projectKeys.size());
        return projectsSearch.flatMap(response -> {
            List projects = response.getHits().stream().map(SearchProjectHit::of).map(SearchProjectHit::getId).map(projectId -> {
                try {
                    return this.projectService.getById(projectId.intValue());
                }
                catch (AuthorisationException e) {
                    log.debug("User is not authorised to access project {}", projectId, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return Observable.from(projects);
        });
    }

    @Nonnull
    public Observable<Repository> findRepositoriesByFullIds(@Nonnull Collection<ProjectAndRepository> repoIds, @Nonnull List<Project> projects, @Nonnull EffectivePermissions effectivePermissions) {
        if (repoIds.isEmpty()) {
            return Observable.empty();
        }
        return this.findRepositories(this.queryBuilder.queryForReposByProjectsAndFullIds(projects, repoIds, effectivePermissions), repoIds.size());
    }

    @Nonnull
    public Observable<Repository> findRepositoriesByProjects(@Nonnull Collection<Project> projects, @Nonnull EffectivePermissions effectivePermissions) {
        if (projects.isEmpty()) {
            return Observable.empty();
        }
        return this.findRepositories(this.queryBuilder.queryForReposByProjects(projects, effectivePermissions), projects.size() * 100);
    }

    @Nonnull
    public Observable<Repository> findRepositoriesBySlugs(@Nonnull Collection<String> repoSlugs, @Nonnull Collection<Project> projects, @Nonnull EffectivePermissions effectivePermissions) {
        if (repoSlugs.isEmpty()) {
            return Observable.empty();
        }
        return this.findRepositories(this.queryBuilder.queryForReposByProjectsAndSlugs(projects, repoSlugs, effectivePermissions), repoSlugs.size() * projects.size());
    }

    private Observable<Repository> findRepositories(QueryBuilder queryBuilder, int maxResults) {
        Observable<SearchResponse> repoSearch = this.searchFor(RepositoryMapping.type(), queryBuilder, maxResults);
        return repoSearch.flatMap(response -> {
            List repositories = response.getHits().stream().flatMap(hit -> Optionals.toStream(SearchRepositoryHit.of(hit))).map(SearchRepositoryHit::getId).map(repoId -> {
                try {
                    return this.repositoryService.getById(repoId.intValue());
                }
                catch (AuthorisationException e) {
                    log.debug("User is not authorised to access repository {}", repoId, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return Observable.from(repositories);
        });
    }

    private Observable<SearchResponse> searchFor(MappingType docType, QueryBuilder queryBuilder, int maxResults) {
        SearchRequestBuilder request = Requests.request(docType).search().source(ES.searchSource().page(ES.page().from(0).size(maxResults).build()).query(queryBuilder));
        if (log.isDebugEnabled()) {
            log.debug("Search scope resolution query: {}", (Object)queryBuilder.build());
        }
        return this.client.execute(request);
    }
}

