/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.internal.search.search.scope.InvalidProjectModifierValueException;
import com.atlassian.bitbucket.internal.search.search.scope.InvalidQueryScopeException;
import com.atlassian.bitbucket.internal.search.search.scope.InvalidRepositoryModifierValueException;
import com.atlassian.bitbucket.internal.search.search.scope.OrphanRepositoryModifierException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ScopeModifiersValidator {
    private ScopeModifiersValidator() {
    }

    public static Optional<InvalidQueryScopeException> validateScopeModifiers(Collection<String> projectKeys, Collection<String> repoSlugs, Collection<String> repoIds) {
        List<String> invalidProjectValues = projectKeys.stream().filter(p -> p.contains("/")).collect(Collectors.toList());
        if (!invalidProjectValues.isEmpty()) {
            return Optional.of(new InvalidProjectModifierValueException(invalidProjectValues));
        }
        List<String> invalidRepoValues = repoIds.stream().filter(m -> m.startsWith("/") || m.endsWith("/") || m.chars().filter(c -> c == 47).count() > 1L).collect(Collectors.toList());
        if (!invalidRepoValues.isEmpty()) {
            return Optional.of(new InvalidRepositoryModifierValueException(invalidRepoValues));
        }
        if (projectKeys.isEmpty() && repoSlugs.size() > 0) {
            return Optional.of(new OrphanRepositoryModifierException(repoSlugs));
        }
        return Optional.empty();
    }
}

