/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.common.util.Optionals;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.query.AbstractSearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.scope.ProjectAndRepository;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.TermsQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

class ScopeResolvingQueryBuilder
extends AbstractSearchQueryBuilder {
    public ScopeResolvingQueryBuilder() {
        super(RepositoryMapping.ID, RepositoryMapping.PROJECT_ID, RepositoryMapping.PUBLIC);
    }

    public QueryBuilder queryForProjectsByKey(Collection<String> projectKeys) {
        return ES.boolQuery().filter((QueryBuilder)ES.termsQuery((String)ProjectMapping.KEY.fieldName()).values((Iterable)projectKeys.stream().map(key -> key.toLowerCase(Locale.US)).distinct().map(StringValue::of).collect(Collectors.toList())));
    }

    public QueryBuilder queryForReposByProjects(Collection<Project> projects, EffectivePermissions effectivePermissions) {
        ArrayList<TermsQueryBuilder> filters = new ArrayList<TermsQueryBuilder>();
        filters.add(ES.termsQuery((String)RepositoryMapping.PROJECT_ID.fieldName()).values((Iterable)projects.stream().map(p -> NumberValue.of((Number)p.getId())).collect(Collectors.toList())));
        this.createPermissionFilter(effectivePermissions).ifPresent(filters::add);
        return ES.boolQuery().filters(filters);
    }

    public QueryBuilder queryForReposByProjectsAndFullIds(Collection<Project> projects, Collection<ProjectAndRepository> repoIds, EffectivePermissions effectivePermissions) {
        ArrayList<QueryBuilder> shoulds = new ArrayList<QueryBuilder>();
        repoIds.stream().flatMap(repoId -> Optionals.toStream(projects.stream().filter(p -> p.getKey().equalsIgnoreCase(repoId.getProjectKey())).findFirst().map(p -> ES.boolQuery().must((QueryBuilder)ES.termsQuery((String)RepositoryMapping.PROJECT_ID.fieldName()).value((Value)NumberValue.of((Number)p.getId()))).must((QueryBuilder)ES.termsQuery((String)RepositoryMapping.SLUG.fieldName()).value((Value)StringValue.of((String)repoId.getRepositorySlug().toLowerCase(Locale.US))))))).forEach(shoulds::add);
        ArrayList filters = new ArrayList();
        ScopeResolvingQueryBuilder.combineShouldFilters(shoulds).ifPresent(filters::add);
        this.createPermissionFilter(effectivePermissions).ifPresent(filters::add);
        return ES.boolQuery().filters(filters);
    }

    public QueryBuilder queryForReposByProjectsAndSlugs(Collection<Project> projects, Collection<String> repoSlugs, EffectivePermissions effectivePermissions) {
        ArrayList<TermsQueryBuilder> filters = new ArrayList<TermsQueryBuilder>();
        filters.add(ES.termsQuery((String)RepositoryMapping.PROJECT_ID.fieldName()).values((Iterable)projects.stream().map(p -> NumberValue.of((Number)p.getId())).collect(Collectors.toList())));
        filters.add(ES.termsQuery((String)RepositoryMapping.SLUG.fieldName()).values((Iterable)repoSlugs.stream().map(slug -> slug.toLowerCase(Locale.US)).distinct().map(StringValue::of).collect(Collectors.toList())));
        this.createPermissionFilter(effectivePermissions).ifPresent(filters::add);
        return ES.boolQuery().filters(filters);
    }
}

