/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.scope;

import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import com.atlassian.bitbucket.internal.search.search.permission.SecurityContext;
import com.atlassian.bitbucket.internal.search.search.query.Modifier;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.scope.DefaultResultScope;
import com.atlassian.bitbucket.internal.search.search.scope.DefaultScope;
import com.atlassian.bitbucket.internal.search.search.scope.InvalidQueryScopeException;
import com.atlassian.bitbucket.internal.search.search.scope.ProjectAndRepository;
import com.atlassian.bitbucket.internal.search.search.scope.ProjectAndRepositoryFinder;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.bitbucket.internal.search.search.scope.ScopeModifiersValidator;
import com.atlassian.bitbucket.internal.search.search.scope.ScopeResolver;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class ServerScopeResolver
implements ScopeResolver {
    private static final int MAX_RESULTS = 40;
    private final ProjectAndRepositoryFinder finder;

    @Autowired
    public ServerScopeResolver(ProjectAndRepositoryFinder finder) {
        this.finder = finder;
    }

    @Override
    @Nonnull
    public Observable<Scope> resolveScope(Query query, SecurityContext securityContext) {
        List repoIds;
        List<String> projectKeys = query.getModifierValue(Modifier.PROJECT).stream().distinct().collect(Collectors.toList());
        List<String> repoModifiers = query.getModifierValue(Modifier.REPOSITORY).stream().distinct().collect(Collectors.toList());
        if (projectKeys.isEmpty() && repoModifiers.isEmpty()) {
            return Observable.just((Object)DefaultScope.everything());
        }
        Pair<List<String>, List<String>> pair = ServerScopeResolver.separateRepoSlugsAndFullIdentifiers(repoModifiers);
        List repoSlugs = (List)pair.left();
        Optional<InvalidQueryScopeException> validationError = ScopeModifiersValidator.validateScopeModifiers(projectKeys, repoSlugs, repoIds = (List)pair.right());
        if (validationError.isPresent()) {
            return Observable.error((Throwable)validationError.get());
        }
        List<ProjectAndRepository> parsedRepoIds = repoIds.stream().map(id -> {
            int i = id.indexOf(47);
            return ProjectAndRepository.builder().projectKey(id.substring(0, i)).repositorySlug(id.substring(i + 1)).build();
        }).collect(Collectors.toList());
        return this.resolveScope(projectKeys, repoSlugs, parsedRepoIds, securityContext.resolveEffectivePermissions()).map(scope -> ServerScopeResolver.wrapWithProperResultScope(scope, projectKeys, repoSlugs, parsedRepoIds));
    }

    private static Pair<List<String>, List<String>> separateRepoSlugsAndFullIdentifiers(List<String> mixedRepoModifierValues) {
        ArrayList repoSlugs = new ArrayList();
        ArrayList repoIds = new ArrayList();
        mixedRepoModifierValues.forEach(val -> {
            if (val.contains("/")) {
                repoIds.add(val);
            } else {
                repoSlugs.add(val);
            }
        });
        return Pair.pair(repoSlugs, repoIds);
    }

    private static Scope wrapWithProperResultScope(Scope scope, List<String> projectKeys, List<String> repoSlugs, List<ProjectAndRepository> repoIds) {
        Collection<Project> projects = scope.getProjects();
        Collection<Repository> repositories = scope.getRepositories();
        if (projects.size() == 1 && repositories.isEmpty() && repoSlugs.isEmpty() && repoIds.isEmpty()) {
            Project scopeProject = projects.iterator().next();
            if (projectKeys.stream().allMatch(key -> key.equalsIgnoreCase(scopeProject.getKey()))) {
                return DefaultScope.builder().resultScope(DefaultResultScope.project(scopeProject)).projects(projects).build();
            }
        } else if (projects.isEmpty() && repositories.size() == 1) {
            Repository scopeRepository = repositories.iterator().next();
            String scopeProjectKey = scopeRepository.getProject().getKey();
            String scopeRepoSlug = scopeRepository.getSlug();
            boolean allProjectKeysMatchScopeRepository = projectKeys.stream().allMatch(key -> key.equalsIgnoreCase(scopeProjectKey));
            boolean allRepositorySlugsMatchScopeRepository = repoSlugs.stream().allMatch(slug -> slug.equalsIgnoreCase(scopeRepoSlug));
            boolean allFullRepositoryIdsMatchScopeRepository = repoIds.stream().allMatch(repoId -> repoId.getProjectKey().equalsIgnoreCase(scopeProjectKey) && repoId.getRepositorySlug().equalsIgnoreCase(scopeRepoSlug));
            if (allProjectKeysMatchScopeRepository && allRepositorySlugsMatchScopeRepository && allFullRepositoryIdsMatchScopeRepository) {
                return DefaultScope.builder().resultScope(DefaultResultScope.repository(scopeRepository)).repositories(repositories).build();
            }
        }
        return scope;
    }

    private boolean isProjectExplicitlyAccessible(Project project, EffectivePermissions effectivePermissions) {
        return effectivePermissions.globalPermissionLevel() == PermissionLevel.READ || effectivePermissions.canAccessPublicRepositories() && project.isPublic() || effectivePermissions.accessibleProjects().contains(project.getId());
    }

    private Observable<Scope> resolveScope(List<ProjectAndRepository> repoIds, EffectivePermissions effectivePermissions) {
        Observable<Project> projectObservable = this.finder.findProjects(repoIds.stream().map(ProjectAndRepository::getProjectKey).distinct().collect(Collectors.toList()));
        return projectObservable.buffer(40).flatMap(projects -> this.finder.findRepositoriesByFullIds((Collection<ProjectAndRepository>)repoIds, (List<Project>)projects, effectivePermissions)).buffer(40).map(repos -> DefaultScope.builder().repositories((Collection<Repository>)repos).build()).defaultIfEmpty((Object)DefaultScope.nothing());
    }

    private Observable<Scope> resolveScope(List<String> projectKeys, List<String> repoSlugs, EffectivePermissions effectivePermissions) {
        Observable<Project> projectObservable = this.finder.findProjects(projectKeys);
        if (repoSlugs.isEmpty()) {
            return projectObservable.buffer(40).flatMap(projects -> this.visibleProjects((Collection<Project>)projects, effectivePermissions)).buffer(40).map(projects -> DefaultScope.builder().projects((Collection<Project>)projects).build()).defaultIfEmpty((Object)DefaultScope.nothing());
        }
        return projectObservable.buffer(40).flatMap(projects -> this.finder.findRepositoriesBySlugs((Collection<String>)repoSlugs, (Collection<Project>)projects, effectivePermissions)).buffer(40).map(repos -> DefaultScope.builder().repositories((Collection<Repository>)repos).build()).defaultIfEmpty((Object)DefaultScope.nothing());
    }

    private Observable<Scope> resolveScope(List<String> projectKeys, List<String> repoSlugs, List<ProjectAndRepository> repoIds, EffectivePermissions effectivePermissions) {
        List<ProjectAndRepository> filteredRepoIds = repoIds.stream().filter(repoId -> projectKeys.isEmpty() || projectKeys.contains(repoId.getProjectKey())).filter(repoId -> repoSlugs.isEmpty() || repoSlugs.contains(repoId.getRepositorySlug())).collect(Collectors.toList());
        if (filteredRepoIds.isEmpty() && !repoIds.isEmpty()) {
            return Observable.just((Object)DefaultScope.nothing());
        }
        return filteredRepoIds.isEmpty() ? this.resolveScope(projectKeys, repoSlugs, effectivePermissions) : this.resolveScope(filteredRepoIds, effectivePermissions);
    }

    private Observable<Project> visibleProjects(Collection<Project> projects, EffectivePermissions effectivePermissions) {
        Map<Boolean, List<Project>> projectsMap = projects.stream().collect(Collectors.partitioningBy(p -> this.isProjectExplicitlyAccessible((Project)p, effectivePermissions)));
        List<Project> accessibleProjects = projectsMap.get(Boolean.TRUE);
        List<Project> maybeVisibleProjects = projectsMap.get(Boolean.FALSE);
        Observable visibleProjects = this.finder.findRepositoriesByProjects(maybeVisibleProjects, effectivePermissions).flatMap(repository -> Observable.just((Object)repository.getProject())).distinct();
        return Observable.concat((Observable)Observable.from(accessibleProjects), (Observable)visibleProjects);
    }
}

