/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.security;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.permission.DmzPermissionService;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import com.atlassian.bitbucket.internal.search.search.permission.SecurityContext;
import com.atlassian.bitbucket.internal.search.search.permission.SimpleEffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.SimpleSecurityContext;
import com.atlassian.bitbucket.internal.search.search.security.EffectivePermissionsVisitor;
import com.atlassian.bitbucket.internal.search.search.security.HostSecurityService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultHostSecurityService
implements HostSecurityService {
    private final AuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final DmzPermissionService permissionService;

    @Autowired
    public DefaultHostSecurityService(AuthenticationContext authenticationContext, FeatureManager featureManager, DmzPermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.permissionService = permissionService;
    }

    @Override
    @Nonnull
    public SecurityContext resolveSecurityContext() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        return SimpleSecurityContext.builder().user(user).effectivePermissions(this.calculateEffectivePermissions(user)).build();
    }

    private static EffectivePermissions emptyEffectivePermissions(boolean publicAccessEnabled) {
        return SimpleEffectivePermissions.builder().canAccessPublicRepositories(publicAccessEnabled).globalPermissionLevel(PermissionLevel.NONE).projectIds(Collections.emptySet()).repositoryIds(Collections.emptySet()).build();
    }

    private EffectivePermissions calculateEffectivePermissions(ApplicationUser user) {
        boolean publicAccessEnabled = this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS);
        if (user == null) {
            return DefaultHostSecurityService.emptyEffectivePermissions(publicAccessEnabled);
        }
        EffectivePermissionsVisitor visitor = new EffectivePermissionsVisitor();
        this.permissionService.getEffectivePermissions(user).forEach(effectivePermission -> effectivePermission.accept((EffectivePermissionVisitor)visitor));
        return visitor.build(publicAccessEnabled);
    }
}

