/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.security;

import com.atlassian.bitbucket.dmz.permission.AbstractEffectivePermissionVisitor;
import com.atlassian.bitbucket.dmz.permission.EffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveRepositoryPermission;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import com.atlassian.bitbucket.internal.search.search.permission.SimpleEffectivePermissions;
import com.atlassian.bitbucket.permission.Permission;
import jakarta.annotation.Nonnull;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

class EffectivePermissionsVisitor
extends AbstractEffectivePermissionVisitor<Void> {
    private static final EnumSet<Permission> PROJECT_READ_PERMISSIONS = EnumSet.copyOf(Permission.PROJECT_READ.getInheritingPermissions());
    private static final EnumSet<Permission> REPOSITORY_READ_PERMISSIONS = EnumSet.copyOf(Permission.REPO_READ.getInheritingPermissions());
    private final Set<Integer> projectIdBuilder = new HashSet<Integer>();
    private final Set<Integer> repositoryIdBuilder = new HashSet<Integer>();
    private PermissionLevel globalPermissionLevel = PermissionLevel.NONE;

    EffectivePermissionsVisitor() {
    }

    public Void visit(@Nonnull EffectiveGlobalPermission permission) {
        if (PermissionLevel.NONE.equals((Object)this.globalPermissionLevel) && REPOSITORY_READ_PERMISSIONS.contains(permission.getPermission())) {
            this.globalPermissionLevel = PermissionLevel.READ;
        }
        return (Void)super.visit(permission);
    }

    public Void visit(@Nonnull EffectiveRepositoryPermission permission) {
        if (REPOSITORY_READ_PERMISSIONS.contains(permission.getPermission())) {
            this.repositoryIdBuilder.add(permission.getRepositoryId());
        }
        return (Void)super.visit(permission);
    }

    public Void visit(@Nonnull EffectiveProjectPermission permission) {
        if (PROJECT_READ_PERMISSIONS.contains(permission.getPermission())) {
            this.projectIdBuilder.add(permission.getProjectId());
        }
        return (Void)super.visit(permission);
    }

    EffectivePermissions build(boolean publicAccessEnabled) {
        return SimpleEffectivePermissions.builder().globalPermissionLevel(this.globalPermissionLevel).projectIds(this.projectIdBuilder).repositoryIds(this.repositoryIdBuilder).canAccessPublicRepositories(PermissionLevel.READ.equals((Object)this.globalPermissionLevel) || publicAccessEnabled).build();
    }
}

