/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.version;

import com.atlassian.bitbucket.internal.search.indexing.administration.FieldDataTypes;
import com.atlassian.bitbucket.search.SearchDistribution;
import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SearchVersion {
    private final SearchDistribution distribution;
    private final FieldDataTypes fieldDataTypes;
    private final boolean isSupported;
    private final Version version;

    private SearchVersion(Builder builder) {
        this.distribution = builder.distribution;
        this.fieldDataTypes = builder.fieldDataTypes;
        this.isSupported = builder.isSupported;
        this.version = builder.version;
    }

    @Nonnull
    public static Builder builder(@Nonnull SearchDistribution distribution, @Nonnull FieldDataTypes fieldDataTypes, @Nonnull Version version) {
        return new Builder(distribution, fieldDataTypes, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchVersion that = (SearchVersion)o;
        return this.distribution == that.distribution && Objects.equals(this.version, that.version);
    }

    @Nonnull
    public SearchDistribution getDistribution() {
        return this.distribution;
    }

    @Nonnull
    public FieldDataTypes getFieldDataTypes() {
        return this.fieldDataTypes;
    }

    @Nonnull
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.distribution, this.version);
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public static class Builder {
        private final SearchDistribution distribution;
        private final FieldDataTypes fieldDataTypes;
        private final Version version;
        private boolean isSupported;

        public Builder(@Nonnull SearchDistribution distribution, @Nonnull FieldDataTypes fieldDataTypes, @Nonnull Version version) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            this.fieldDataTypes = Objects.requireNonNull(fieldDataTypes, "fieldDataTypes");
            this.version = Objects.requireNonNull(version, "version");
        }

        @Nonnull
        public SearchVersion build() {
            return new SearchVersion(this);
        }

        @Nonnull
        public Builder isSupported(boolean isSupported) {
            this.isSupported = isSupported;
            return this;
        }
    }
}

