/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.version;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.administration.SearchVersionRequestBuilder;
import com.atlassian.bitbucket.internal.search.search.UnsuccessfulResponseException;
import com.atlassian.bitbucket.internal.search.version.ElasticsearchVersionFactory;
import com.atlassian.bitbucket.internal.search.version.OpenSearchVersionFactory;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.internal.search.version.SearchVersionFactory;
import com.atlassian.bitbucket.search.SearchDistribution;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.elasticsearch.client.request.Response;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import rx.Observable;

public class SearchVersionUtils {
    private SearchVersionUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " only contains static utility methods and should not be instantiated.");
    }

    @Nonnull
    public static Observable<SearchVersion> getVersion(@Nonnull SearchClient client) {
        Objects.requireNonNull(client, "client");
        return client.execute(new SearchVersionRequestBuilder()).map(response -> {
            String searchDistributionString = response.getDistribution().orElse(null);
            return response.getVersion().map(versionString -> SearchVersionUtils.getVersionFactory(searchDistributionString, versionString).create()).orElseThrow(() -> new UnsuccessfulResponseException((Response)response, "Bitbucket did not have authorization to request data from the search server."));
        });
    }

    @Nonnull
    public static SearchVersionFactory getVersionFactory(@Nullable String distributionString, @Nonnull String versionString) {
        Objects.requireNonNull(versionString, "versionString");
        SearchDistribution distribution = SearchDistribution.fromString((String)distributionString);
        Version version = new Version(versionString);
        return SearchDistribution.OPENSEARCH == distribution ? new OpenSearchVersionFactory(version) : new ElasticsearchVersionFactory(version);
    }
}

