/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.plugins;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TemplateContextItemModuleDescriptor
extends AbstractModuleDescriptor<Object>
implements StateAware {
    private Logger log = LoggerFactory.getLogger(TemplateContextItemModuleDescriptor.class);
    private boolean global = false;
    private String contextKey;
    private String componentRef = null;
    private Object component = null;
    private Supplier<Object> moduleSupplier;

    public TemplateContextItemModuleDescriptor() {
        super(ModuleFactory.LEGACY_MODULE_FACTORY);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        String contextKeyStr;
        super.init(plugin, element);
        String globalStr = element.attributeValue("global");
        if (globalStr != null) {
            this.global = Boolean.parseBoolean(globalStr);
        }
        if ((contextKeyStr = element.attributeValue("context-key")) == null) {
            throw new PluginParseException("context-key must be specified");
        }
        this.contextKey = contextKeyStr;
        String componentRefStr = element.attributeValue("component-ref");
        String classStr = element.attributeValue("class");
        if (componentRefStr != null) {
            if (classStr != null) {
                throw new PluginParseException("You may not specify both a class and a component-ref");
            }
            this.componentRef = componentRefStr;
        } else if (classStr == null) {
            throw new PluginParseException("You must specify a class or a component-ref");
        }
    }

    public synchronized Object getModule() {
        if (this.componentRef != null) {
            if (this.moduleSupplier == null) {
                this.moduleSupplier = this.getModuleSupplier();
            }
            return this.moduleSupplier.get();
        }
        if (this.component == null) {
            this.component = ((ContainerManagedPlugin)this.getPlugin()).getContainerAccessor().createBean(this.getModuleClass());
        }
        return this.component;
    }

    private Supplier<Object> getModuleSupplier() {
        ContainerManagedPlugin containerManagedPlugin;
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            return () -> applicationContext.getBean(this.componentRef);
        }
        Plugin plugin = this.getPlugin();
        if (plugin instanceof ContainerManagedPlugin && (containerManagedPlugin = (ContainerManagedPlugin)plugin).getContainerAccessor() != null) {
            return () -> containerManagedPlugin.getContainerAccessor().getBean(this.componentRef);
        }
        return () -> null;
    }

    private ApplicationContext getApplicationContext() {
        OsgiPlugin osgiPlugin = (OsgiPlugin)this.getPlugin();
        BundleContext bundleContext = osgiPlugin.getBundle().getBundleContext();
        try {
            ServiceReference[] applicationContextServiceReferences = bundleContext.getServiceReferences(ApplicationContext.class.getName(), "(org.springframework.context.service.name=" + osgiPlugin.getBundle().getSymbolicName() + ")");
            if (applicationContextServiceReferences == null || applicationContextServiceReferences.length == 0) {
                this.log.debug("Spring ApplicationContext for the bundle {} is not available from OSGi", (Object)osgiPlugin.getBundle().getSymbolicName());
                return null;
            }
            if (applicationContextServiceReferences.length != 1) {
                this.log.error("Spring DM is being evil, there is not exactly one ApplicationContext for the bundle {}, there are {}", (Object)osgiPlugin.getBundle().getSymbolicName(), (Object)applicationContextServiceReferences.length);
            }
            return (ApplicationContext)bundleContext.getService(applicationContextServiceReferences[0]);
        }
        catch (InvalidSyntaxException ise) {
            this.log.error("Bad filter", (Throwable)ise);
            return null;
        }
    }

    public synchronized void disabled() {
        super.disabled();
        this.component = null;
        this.moduleSupplier = null;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

