/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.api;

import com.atlassian.marketplace.parentsoftware.ApiClient;
import com.atlassian.marketplace.parentsoftware.ApiException;
import com.atlassian.marketplace.parentsoftware.Configuration;
import com.atlassian.marketplace.parentsoftware.Pair;
import com.atlassian.marketplace.parentsoftware.model.ArtifactBase;
import com.atlassian.marketplace.parentsoftware.model.RemoteFetchedSoftwareArtifact;
import com.atlassian.marketplace.parentsoftware.model.UploadedSoftwareArtifact;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;

public class AppSoftwareVersionArtifactApisApi {
    private ApiClient apiClient;

    public AppSoftwareVersionArtifactApisApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppSoftwareVersionArtifactApisApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RemoteFetchedSoftwareArtifact fetchRemoteArtifact(URI uri) throws ApiException {
        Object localVarPostBody = null;
        if (uri == null) {
            throw new ApiException(400, "Missing the required parameter 'uri' when calling fetchRemoteArtifact");
        }
        String localVarPath = "/artifacts/fetch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("uri", uri));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RemoteFetchedSoftwareArtifact> localVarReturnType = new TypeReference<RemoteFetchedSoftwareArtifact>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactBase getArtifact(String artifactId) throws ApiException {
        Object localVarPostBody = null;
        if (artifactId == null) {
            throw new ApiException(400, "Missing the required parameter 'artifactId' when calling getArtifact");
        }
        String localVarPath = "/artifacts/{artifactId}".replaceAll("\\{artifactId\\}", this.apiClient.escapeString(artifactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ArtifactBase> localVarReturnType = new TypeReference<ArtifactBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UploadedSoftwareArtifact uploadArtifact(File _file) throws ApiException {
        Object localVarPostBody = null;
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadArtifact");
        }
        String localVarPath = "/artifacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("file", _file));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<UploadedSoftwareArtifact> localVarReturnType = new TypeReference<UploadedSoftwareArtifact>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

