/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.client;

import com.atlassian.marketplace.parentsoftware.ApiException;
import com.atlassian.marketplace.parentsoftware.api.ParentSoftwareApisApi;
import com.atlassian.marketplace.parentsoftware.api.ParentSoftwareVersionApisApi;
import com.atlassian.marketplace.parentsoftware.client.ParentSoftwareClient;
import com.atlassian.marketplace.parentsoftware.model.PageLinks;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareGetAllResponse;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionGetResponse;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionsGetResponse;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentSoftwareClientImpl
implements ParentSoftwareClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentSoftwareClientImpl.class);
    private static final int DEFAULT_PAGE_SIZE = 50;
    private final int pageSize;
    private final ParentSoftwareApisApi parentSoftwareApi;
    private final ParentSoftwareVersionApisApi parentSoftwareVersionApis;
    private final boolean isDevMode;

    public ParentSoftwareClientImpl(ParentSoftwareApisApi parentSoftwareApi, ParentSoftwareVersionApisApi parentSoftwareVersionApis, int pageSize, boolean isDevMode) {
        this.parentSoftwareApi = parentSoftwareApi;
        this.parentSoftwareVersionApis = parentSoftwareVersionApis;
        this.pageSize = pageSize;
        this.isDevMode = isDevMode;
    }

    public ParentSoftwareClientImpl(ParentSoftwareApisApi parentSoftwareApi, ParentSoftwareVersionApisApi parentSoftwareVersionApis, boolean isDevMode) {
        this(parentSoftwareApi, parentSoftwareVersionApis, 50, isDevMode);
    }

    @Override
    public ParentSoftwareGetAllResponse getAllParentSoftware(Integer limit, String cursor) throws ApiException {
        return this.parentSoftwareApi.getAllParentSoftware(limit, cursor);
    }

    @Override
    public ParentSoftwareVersionGetResponse getParentSoftwareVersionByBuildNumber(String id, Long buildNumber) throws ApiException {
        return this.parentSoftwareVersionApis.getParentSoftwareVersionByBuildNumber(id, buildNumber);
    }

    @Override
    public ParentSoftwareVersionGetResponse getParentSoftwareVersionByVersionNumber(String id, String versionNumber) throws ApiException {
        return this.parentSoftwareVersionApis.getParentSoftwareVersionByVersionNumber(id, versionNumber);
    }

    @Override
    public ParentSoftwareVersionsGetResponse getParentSoftwareVersions(String id, Integer limit, String cursor) throws ApiException {
        return this.parentSoftwareVersionApis.getParentSoftwareVersions(id, limit, cursor);
    }

    @Override
    public ParentSoftwareVersionsGetResponse getParentSoftwareVersions(String id) throws ApiException {
        int limit = this.pageSize;
        ParentSoftwareVersionsGetResponse allResults = new ParentSoftwareVersionsGetResponse();
        ParentSoftwareVersionsGetResponse response = this.getParentSoftwareVersions(id, limit, null);
        List<ParentSoftwareVersionGetResponse> pageResults = response.getVersions();
        allResults.getVersions().addAll(pageResults);
        boolean hasNextPage = this.hasNextPage(response);
        while (hasNextPage) {
            Optional<ParentSoftwareVersionGetResponse> lastVersion = this.getLast(pageResults);
            String cursor = this.nextCursor(response).or(() -> lastVersion.map(v -> String.valueOf(v.getBuildNumber()))).orElse(null);
            response = this.getParentSoftwareVersions(id, limit, cursor);
            pageResults = Optional.ofNullable(response).map(ParentSoftwareVersionsGetResponse::getVersions).orElse(List.of());
            allResults.getVersions().addAll(pageResults);
            hasNextPage = this.hasNextPage(response);
        }
        return allResults;
    }

    private Optional<String> nextCursor(ParentSoftwareVersionsGetResponse response) {
        return Optional.ofNullable(response).map(ParentSoftwareVersionsGetResponse::getLinks).map(PageLinks::getNext).map(URI::create).flatMap(uri -> this.getQueryParameter(uri.getQuery(), "cursor"));
    }

    private boolean hasNextPage(ParentSoftwareVersionsGetResponse response) {
        return Optional.ofNullable(response).map(ParentSoftwareVersionsGetResponse::getLinks).map(links -> links.getNext() != null).orElse(false);
    }

    private <T> Optional<T> getLast(List<T> versions) {
        if (versions == null || versions.isEmpty()) {
            return Optional.empty();
        }
        int last = versions.size() - 1;
        return Optional.of(versions.get(last));
    }

    private Optional<String> getQueryParameter(String queryString, String name) {
        if (queryString == null) {
            return Optional.empty();
        }
        return Arrays.stream(queryString.split("&")).map(s -> s.split("=")).filter(ar -> ar[0].equals(name)).findFirst().map(ar -> ar[1]);
    }

    @Override
    public Optional<ParentSoftwareVersionGetResponse> safeGetParentSoftwareVersionByBuildNumber(String key, Long buildNumber) {
        try {
            return Optional.ofNullable(this.getParentSoftwareVersionByBuildNumber(key, buildNumber));
        }
        catch (ApiException api) {
            if (api.getCode() == 404) {
                this.warn("No version found for '{}' with '{}' build number", key, buildNumber);
            } else {
                this.warn("Exception while getting build number {} of '{}' from Marketplace : {}", buildNumber, key, api.getMessage());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.warn("ParentSoftwareClient error : {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ParentSoftwareVersionGetResponse> safeGetLatestParentSoftwareVersion(String key) {
        try {
            ParentSoftwareVersionsGetResponse response = this.getParentSoftwareVersions(key);
            return response.getVersions().stream().max(Comparator.comparing(ParentSoftwareVersionGetResponse::getBuildNumber));
        }
        catch (ApiException api) {
            if (api.getCode() == 404) {
                this.warn("ParentSoftware '{}' is unknown to Marketplace", key);
            } else {
                this.warn("Exception while getting latest version of '{}' from Marketplace : {}", key, api.getMessage());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.warn("ParentSoftwareClient error : {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    private void warn(String template, Object ... params) {
        if (this.isDevMode) {
            LOGGER.debug(template, params);
        } else {
            LOGGER.warn(template, params);
        }
    }
}

