/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.http;

import com.atlassian.marketplace.parentsoftware.http.HttpConfiguration;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCredentialsProvider.class);
    private final HttpHost proxyHost;
    private final Credentials proxyCredentials;
    private final Credentials targetHostCredentials;

    DefaultCredentialsProvider(HttpConfiguration config, HttpHost proxyHost) {
        this.proxyCredentials = this.makeProxyCredentials(config);
        this.targetHostCredentials = this.makeTargetHostCredentials(config);
        this.proxyHost = proxyHost;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        LOGGER.warn("setCredentials is not implemented : this object is immutable");
    }

    public Credentials getCredentials(AuthScope authScope) {
        if (this.proxyHost != null && this.proxyHost.getHostName().equals(authScope.getHost()) && this.proxyHost.getPort() == authScope.getPort()) {
            return this.proxyCredentials;
        }
        return this.targetHostCredentials;
    }

    public void clear() {
        LOGGER.warn("clear() is not implemented : this object is immutable");
    }

    private Credentials makeProxyCredentials(HttpConfiguration config) {
        return config.getProxyConfiguration().map(HttpConfiguration.ProxyConfiguration::getAuthParams).map(auth -> {
            if (Objects.requireNonNull(auth.getAuthMethod()) == HttpConfiguration.ProxyAuthMethod.NTLM) {
                return new NTCredentials(auth.getCredentials().getUsername(), auth.getCredentials().getPassword(), auth.getNtlmWorkstation(), auth.getNtlmDomain());
            }
            return new UsernamePasswordCredentials(auth.getCredentials().getUsername(), auth.getCredentials().getPassword());
        }).orElse(null);
    }

    private Credentials makeTargetHostCredentials(HttpConfiguration config) {
        return config.getCredentials().map(creds -> new UsernamePasswordCredentials(creds.getUsername(), creds.getPassword())).orElse(null);
    }
}

