/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionChangelog;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionCompatibility;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionFrameworkDetails;
import com.atlassian.marketplace.parentsoftware.model.AppSoftwareVersionLicenseTypeGetResponse;
import com.atlassian.marketplace.parentsoftware.model.SourceCodeLicense;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"buildNumber", "versionNumber", "compatibilities", "supportedPaymentModel", "frameworkDetails", "licenseType", "sourceCodeLicense", "changelog", "supported", "state", "revision"})
@JsonTypeName(value="AppSoftwareVersionGetResponse")
public class AppSoftwareVersionGetResponse {
    public static final String JSON_PROPERTY_BUILD_NUMBER = "buildNumber";
    private Long buildNumber;
    public static final String JSON_PROPERTY_VERSION_NUMBER = "versionNumber";
    private String versionNumber;
    public static final String JSON_PROPERTY_COMPATIBILITIES = "compatibilities";
    private List<AppSoftwareVersionCompatibility> compatibilities = new ArrayList<AppSoftwareVersionCompatibility>();
    public static final String JSON_PROPERTY_SUPPORTED_PAYMENT_MODEL = "supportedPaymentModel";
    private SupportedPaymentModelEnum supportedPaymentModel;
    public static final String JSON_PROPERTY_FRAMEWORK_DETAILS = "frameworkDetails";
    private AppSoftwareVersionFrameworkDetails frameworkDetails;
    public static final String JSON_PROPERTY_LICENSE_TYPE = "licenseType";
    private AppSoftwareVersionLicenseTypeGetResponse licenseType;
    public static final String JSON_PROPERTY_SOURCE_CODE_LICENSE = "sourceCodeLicense";
    private SourceCodeLicense sourceCodeLicense;
    public static final String JSON_PROPERTY_CHANGELOG = "changelog";
    private AppSoftwareVersionChangelog changelog;
    public static final String JSON_PROPERTY_SUPPORTED = "supported";
    private Boolean supported;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Integer revision;

    public AppSoftwareVersionGetResponse buildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Build number for the app software version")
    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public AppSoftwareVersionGetResponse versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Version number of the app software version")
    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public AppSoftwareVersionGetResponse compatibilities(List<AppSoftwareVersionCompatibility> compatibilities) {
        this.compatibilities = compatibilities;
        return this;
    }

    public AppSoftwareVersionGetResponse addCompatibilitiesItem(AppSoftwareVersionCompatibility compatibilitiesItem) {
        this.compatibilities.add(compatibilitiesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Compatibility of the app software version")
    @JsonProperty(value="compatibilities")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AppSoftwareVersionCompatibility> getCompatibilities() {
        return this.compatibilities;
    }

    @JsonProperty(value="compatibilities")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompatibilities(List<AppSoftwareVersionCompatibility> compatibilities) {
        this.compatibilities = compatibilities;
    }

    public AppSoftwareVersionGetResponse supportedPaymentModel(SupportedPaymentModelEnum supportedPaymentModel) {
        this.supportedPaymentModel = supportedPaymentModel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The payment model supported by the app software version.")
    @JsonProperty(value="supportedPaymentModel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SupportedPaymentModelEnum getSupportedPaymentModel() {
        return this.supportedPaymentModel;
    }

    @JsonProperty(value="supportedPaymentModel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedPaymentModel(SupportedPaymentModelEnum supportedPaymentModel) {
        this.supportedPaymentModel = supportedPaymentModel;
    }

    public AppSoftwareVersionGetResponse frameworkDetails(AppSoftwareVersionFrameworkDetails frameworkDetails) {
        this.frameworkDetails = frameworkDetails;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="frameworkDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AppSoftwareVersionFrameworkDetails getFrameworkDetails() {
        return this.frameworkDetails;
    }

    @JsonProperty(value="frameworkDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFrameworkDetails(AppSoftwareVersionFrameworkDetails frameworkDetails) {
        this.frameworkDetails = frameworkDetails;
    }

    public AppSoftwareVersionGetResponse licenseType(AppSoftwareVersionLicenseTypeGetResponse licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licenseType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppSoftwareVersionLicenseTypeGetResponse getLicenseType() {
        return this.licenseType;
    }

    @JsonProperty(value="licenseType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseType(AppSoftwareVersionLicenseTypeGetResponse licenseType) {
        this.licenseType = licenseType;
    }

    public AppSoftwareVersionGetResponse sourceCodeLicense(SourceCodeLicense sourceCodeLicense) {
        this.sourceCodeLicense = sourceCodeLicense;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceCodeLicense")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceCodeLicense getSourceCodeLicense() {
        return this.sourceCodeLicense;
    }

    @JsonProperty(value="sourceCodeLicense")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceCodeLicense(SourceCodeLicense sourceCodeLicense) {
        this.sourceCodeLicense = sourceCodeLicense;
    }

    public AppSoftwareVersionGetResponse changelog(AppSoftwareVersionChangelog changelog) {
        this.changelog = changelog;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="changelog")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AppSoftwareVersionChangelog getChangelog() {
        return this.changelog;
    }

    @JsonProperty(value="changelog")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChangelog(AppSoftwareVersionChangelog changelog) {
        this.changelog = changelog;
    }

    public AppSoftwareVersionGetResponse supported(Boolean supported) {
        this.supported = supported;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="States whether the app software version is officially supported.")
    @JsonProperty(value="supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSupported() {
        return this.supported;
    }

    @JsonProperty(value="supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupported(Boolean supported) {
        this.supported = supported;
    }

    public AppSoftwareVersionGetResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the app software version.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public AppSoftwareVersionGetResponse revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The revision number of the app software version.")
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSoftwareVersionGetResponse appSoftwareVersionGetResponse = (AppSoftwareVersionGetResponse)o;
        return Objects.equals(this.buildNumber, appSoftwareVersionGetResponse.buildNumber) && Objects.equals(this.versionNumber, appSoftwareVersionGetResponse.versionNumber) && Objects.equals(this.compatibilities, appSoftwareVersionGetResponse.compatibilities) && Objects.equals((Object)this.supportedPaymentModel, (Object)appSoftwareVersionGetResponse.supportedPaymentModel) && Objects.equals(this.frameworkDetails, appSoftwareVersionGetResponse.frameworkDetails) && Objects.equals(this.licenseType, appSoftwareVersionGetResponse.licenseType) && Objects.equals(this.sourceCodeLicense, appSoftwareVersionGetResponse.sourceCodeLicense) && Objects.equals(this.changelog, appSoftwareVersionGetResponse.changelog) && Objects.equals(this.supported, appSoftwareVersionGetResponse.supported) && Objects.equals((Object)this.state, (Object)appSoftwareVersionGetResponse.state) && Objects.equals(this.revision, appSoftwareVersionGetResponse.revision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildNumber, this.versionNumber, this.compatibilities, this.supportedPaymentModel, this.frameworkDetails, this.licenseType, this.sourceCodeLicense, this.changelog, this.supported, this.state, this.revision});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSoftwareVersionGetResponse {\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    compatibilities: ").append(this.toIndentedString(this.compatibilities)).append("\n");
        sb.append("    supportedPaymentModel: ").append(this.toIndentedString((Object)this.supportedPaymentModel)).append("\n");
        sb.append("    frameworkDetails: ").append(this.toIndentedString(this.frameworkDetails)).append("\n");
        sb.append("    licenseType: ").append(this.toIndentedString(this.licenseType)).append("\n");
        sb.append("    sourceCodeLicense: ").append(this.toIndentedString(this.sourceCodeLicense)).append("\n");
        sb.append("    changelog: ").append(this.toIndentedString(this.changelog)).append("\n");
        sb.append("    supported: ").append(this.toIndentedString(this.supported)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupportedPaymentModelEnum {
        FREE("free"),
        PAIDVIAATLASSIAN("paidViaAtlassian"),
        PAIDVIAVENDOR("paidViaVendor");

        private String value;

        private SupportedPaymentModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportedPaymentModelEnum fromValue(String value) {
            for (SupportedPaymentModelEnum b : SupportedPaymentModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StateEnum {
        DRAFT("draft"),
        SUBMITTED("submitted"),
        APPROVED("approved"),
        ACTIVE("active"),
        REJECTED("rejected"),
        ARCHIVED("archived");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

