/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Represents an artifact which was uploaded from local file system")
@JsonPropertyOrder(value={"logicalFileName", "size"})
@JsonTypeName(value="ArtifactFileInfo")
public class ArtifactFileInfo {
    public static final String JSON_PROPERTY_LOGICAL_FILE_NAME = "logicalFileName";
    private String logicalFileName;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;

    public ArtifactFileInfo logicalFileName(String logicalFileName) {
        this.logicalFileName = logicalFileName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Logical name of the artifact file")
    @JsonProperty(value="logicalFileName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLogicalFileName() {
        return this.logicalFileName;
    }

    @JsonProperty(value="logicalFileName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLogicalFileName(String logicalFileName) {
        this.logicalFileName = logicalFileName;
    }

    public ArtifactFileInfo size(Long size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Size of the artifact file")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactFileInfo artifactFileInfo = (ArtifactFileInfo)o;
        return Objects.equals(this.logicalFileName, artifactFileInfo.logicalFileName) && Objects.equals(this.size, artifactFileInfo.size);
    }

    public int hashCode() {
        return Objects.hash(this.logicalFileName, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArtifactFileInfo {\n");
        sb.append("    logicalFileName: ").append(this.toIndentedString(this.logicalFileName)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

