/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Error entity")
@JsonPropertyOrder(value={"id", "status", "code", "title", "detail"})
@JsonTypeName(value="ErrorEntity")
public class ErrorEntity {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_DETAIL = "detail";
    private String detail;

    public ErrorEntity id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="f0bca12d-4513-41ca-ae36-802536909cc5", value="Unique identifier for this error occurrence")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ErrorEntity status(String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="404", required=true, value="Numerical HTTP status code, as a string")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(String status) {
        this.status = status;
    }

    public ErrorEntity code(String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="NOT_FOUND", required=true, value="A machine readable string code")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(String code) {
        this.code = code;
    }

    public ErrorEntity title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="The resource was not found.", required=true, value="A short, human-readable, summary of the problem")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(String title) {
        this.title = title;
    }

    public ErrorEntity detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="No parent software found with id '$id'", required=true, value="A human-readable explanation of this occurrence of the error")
    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEntity errorEntity = (ErrorEntity)o;
        return Objects.equals(this.id, errorEntity.id) && Objects.equals(this.status, errorEntity.status) && Objects.equals(this.code, errorEntity.code) && Objects.equals(this.title, errorEntity.title) && Objects.equals(this.detail, errorEntity.detail);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.code, this.title, this.detail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

