/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.atlassian.marketplace.parentsoftware.model.ExtensibilityFramework;
import com.atlassian.marketplace.parentsoftware.model.HostingOption;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareLegacyDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Detailed information about a Parent Software with legacy fields")
@JsonPropertyOrder(value={"id", "name", "hostingOptions", "extensibilityFrameworks", "legacyDetails"})
@JsonTypeName(value="LegacyParentSoftwareCreateRequest")
public class LegacyParentSoftwareCreateRequest {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_HOSTING_OPTIONS = "hostingOptions";
    private List<HostingOption> hostingOptions = new ArrayList<HostingOption>();
    public static final String JSON_PROPERTY_EXTENSIBILITY_FRAMEWORKS = "extensibilityFrameworks";
    private List<ExtensibilityFramework> extensibilityFrameworks = new ArrayList<ExtensibilityFramework>();
    public static final String JSON_PROPERTY_LEGACY_DETAILS = "legacyDetails";
    private ParentSoftwareLegacyDetails legacyDetails;

    public LegacyParentSoftwareCreateRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique identifier for a parent software.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public LegacyParentSoftwareCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name for a parent software.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LegacyParentSoftwareCreateRequest hostingOptions(List<HostingOption> hostingOptions) {
        this.hostingOptions = hostingOptions;
        return this;
    }

    public LegacyParentSoftwareCreateRequest addHostingOptionsItem(HostingOption hostingOptionsItem) {
        this.hostingOptions.add(hostingOptionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Properties related to this parent software's availability for a hosting.")
    @JsonProperty(value="hostingOptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HostingOption> getHostingOptions() {
        return this.hostingOptions;
    }

    @JsonProperty(value="hostingOptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHostingOptions(List<HostingOption> hostingOptions) {
        this.hostingOptions = hostingOptions;
    }

    public LegacyParentSoftwareCreateRequest extensibilityFrameworks(List<ExtensibilityFramework> extensibilityFrameworks) {
        this.extensibilityFrameworks = extensibilityFrameworks;
        return this;
    }

    public LegacyParentSoftwareCreateRequest addExtensibilityFrameworksItem(ExtensibilityFramework extensibilityFrameworksItem) {
        this.extensibilityFrameworks.add(extensibilityFrameworksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Properties related to this parent software's extensibility frameworks.")
    @JsonProperty(value="extensibilityFrameworks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ExtensibilityFramework> getExtensibilityFrameworks() {
        return this.extensibilityFrameworks;
    }

    @JsonProperty(value="extensibilityFrameworks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExtensibilityFrameworks(List<ExtensibilityFramework> extensibilityFrameworks) {
        this.extensibilityFrameworks = extensibilityFrameworks;
    }

    public LegacyParentSoftwareCreateRequest legacyDetails(ParentSoftwareLegacyDetails legacyDetails) {
        this.legacyDetails = legacyDetails;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="legacyDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParentSoftwareLegacyDetails getLegacyDetails() {
        return this.legacyDetails;
    }

    @JsonProperty(value="legacyDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegacyDetails(ParentSoftwareLegacyDetails legacyDetails) {
        this.legacyDetails = legacyDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyParentSoftwareCreateRequest legacyParentSoftwareCreateRequest = (LegacyParentSoftwareCreateRequest)o;
        return Objects.equals(this.id, legacyParentSoftwareCreateRequest.id) && Objects.equals(this.name, legacyParentSoftwareCreateRequest.name) && Objects.equals(this.hostingOptions, legacyParentSoftwareCreateRequest.hostingOptions) && Objects.equals(this.extensibilityFrameworks, legacyParentSoftwareCreateRequest.extensibilityFrameworks) && Objects.equals(this.legacyDetails, legacyParentSoftwareCreateRequest.legacyDetails);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.hostingOptions, this.extensibilityFrameworks, this.legacyDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegacyParentSoftwareCreateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hostingOptions: ").append(this.toIndentedString(this.hostingOptions)).append("\n");
        sb.append("    extensibilityFrameworks: ").append(this.toIndentedString(this.extensibilityFrameworks)).append("\n");
        sb.append("    legacyDetails: ").append(this.toIndentedString(this.legacyDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

