/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.atlassian.marketplace.parentsoftware.model.ExtensibilityFramework;
import com.atlassian.marketplace.parentsoftware.model.HostingOption;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareLegacyDetails;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"name", "hostingOptions", "extensibilityFrameworks", "state", "legacyDetails", "revision"})
@JsonTypeName(value="LegacyParentSoftwareUpdateRequest")
public class LegacyParentSoftwareUpdateRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_HOSTING_OPTIONS = "hostingOptions";
    private List<HostingOption> hostingOptions = new ArrayList<HostingOption>();
    public static final String JSON_PROPERTY_EXTENSIBILITY_FRAMEWORKS = "extensibilityFrameworks";
    private List<ExtensibilityFramework> extensibilityFrameworks = new ArrayList<ExtensibilityFramework>();
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_LEGACY_DETAILS = "legacyDetails";
    private ParentSoftwareLegacyDetails legacyDetails;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Integer revision;

    public LegacyParentSoftwareUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name for a parent software.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LegacyParentSoftwareUpdateRequest hostingOptions(List<HostingOption> hostingOptions) {
        this.hostingOptions = hostingOptions;
        return this;
    }

    public LegacyParentSoftwareUpdateRequest addHostingOptionsItem(HostingOption hostingOptionsItem) {
        this.hostingOptions.add(hostingOptionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Properties related to this parent software's availability for a hosting.")
    @JsonProperty(value="hostingOptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HostingOption> getHostingOptions() {
        return this.hostingOptions;
    }

    @JsonProperty(value="hostingOptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHostingOptions(List<HostingOption> hostingOptions) {
        this.hostingOptions = hostingOptions;
    }

    public LegacyParentSoftwareUpdateRequest extensibilityFrameworks(List<ExtensibilityFramework> extensibilityFrameworks) {
        this.extensibilityFrameworks = extensibilityFrameworks;
        return this;
    }

    public LegacyParentSoftwareUpdateRequest addExtensibilityFrameworksItem(ExtensibilityFramework extensibilityFrameworksItem) {
        this.extensibilityFrameworks.add(extensibilityFrameworksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Properties related to this parent software's extensibility frameworks.")
    @JsonProperty(value="extensibilityFrameworks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ExtensibilityFramework> getExtensibilityFrameworks() {
        return this.extensibilityFrameworks;
    }

    @JsonProperty(value="extensibilityFrameworks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExtensibilityFrameworks(List<ExtensibilityFramework> extensibilityFrameworks) {
        this.extensibilityFrameworks = extensibilityFrameworks;
    }

    public LegacyParentSoftwareUpdateRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A state in the lifecycle of a software.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public LegacyParentSoftwareUpdateRequest legacyDetails(ParentSoftwareLegacyDetails legacyDetails) {
        this.legacyDetails = legacyDetails;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="legacyDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParentSoftwareLegacyDetails getLegacyDetails() {
        return this.legacyDetails;
    }

    @JsonProperty(value="legacyDetails")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegacyDetails(ParentSoftwareLegacyDetails legacyDetails) {
        this.legacyDetails = legacyDetails;
    }

    public LegacyParentSoftwareUpdateRequest revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyParentSoftwareUpdateRequest legacyParentSoftwareUpdateRequest = (LegacyParentSoftwareUpdateRequest)o;
        return Objects.equals(this.name, legacyParentSoftwareUpdateRequest.name) && Objects.equals(this.hostingOptions, legacyParentSoftwareUpdateRequest.hostingOptions) && Objects.equals(this.extensibilityFrameworks, legacyParentSoftwareUpdateRequest.extensibilityFrameworks) && Objects.equals((Object)this.state, (Object)legacyParentSoftwareUpdateRequest.state) && Objects.equals(this.legacyDetails, legacyParentSoftwareUpdateRequest.legacyDetails) && Objects.equals(this.revision, legacyParentSoftwareUpdateRequest.revision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hostingOptions, this.extensibilityFrameworks, this.state, this.legacyDetails, this.revision});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegacyParentSoftwareUpdateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hostingOptions: ").append(this.toIndentedString(this.hostingOptions)).append("\n");
        sb.append("    extensibilityFrameworks: ").append(this.toIndentedString(this.extensibilityFrameworks)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    legacyDetails: ").append(this.toIndentedString(this.legacyDetails)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        DRAFT("draft"),
        ACTIVE("active"),
        ARCHIVED("archived");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

