/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents details of a link")
@JsonPropertyOrder(value={"href", "type", "title"})
@JsonTypeName(value="Link")
public class Link {
    public static final String JSON_PROPERTY_HREF = "href";
    private URI href;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public Link href(URI href) {
        this.href = href;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents URL of the link")
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHref(URI href) {
        this.href = href;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the mime type of the link")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the title of the link")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.href, link.href) && Objects.equals(this.type, link.type) && Objects.equals(this.title, link.title);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.type, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

