/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.parentsoftware.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"buildNumber", "versionNumber", "hosting", "state", "revision", "createdAt"})
@JsonTypeName(value="ParentSoftwareVersionGetResponse")
public class ParentSoftwareVersionGetResponse {
    public static final String JSON_PROPERTY_BUILD_NUMBER = "buildNumber";
    private Long buildNumber;
    public static final String JSON_PROPERTY_VERSION_NUMBER = "versionNumber";
    private String versionNumber;
    public static final String JSON_PROPERTY_HOSTING = "hosting";
    private List<HostingEnum> hosting = new ArrayList<HostingEnum>();
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Integer revision;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;

    public ParentSoftwareVersionGetResponse buildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Build number for the parent software version")
    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public ParentSoftwareVersionGetResponse versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Version Number of the parent software version")
    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public ParentSoftwareVersionGetResponse hosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
        return this;
    }

    public ParentSoftwareVersionGetResponse addHostingItem(HostingEnum hostingItem) {
        this.hosting.add(hostingItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Hosting types for which this parent software version is available.")
    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HostingEnum> getHosting() {
        return this.hosting;
    }

    @JsonProperty(value="hosting")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHosting(List<HostingEnum> hosting) {
        this.hosting = hosting;
    }

    public ParentSoftwareVersionGetResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A state in the lifecycle of a software.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ParentSoftwareVersionGetResponse revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The revision number of the parent software version.")
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public ParentSoftwareVersionGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Time Stamp at which first time ParentSoftware was created")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentSoftwareVersionGetResponse parentSoftwareVersionGetResponse = (ParentSoftwareVersionGetResponse)o;
        return Objects.equals(this.buildNumber, parentSoftwareVersionGetResponse.buildNumber) && Objects.equals(this.versionNumber, parentSoftwareVersionGetResponse.versionNumber) && Objects.equals(this.hosting, parentSoftwareVersionGetResponse.hosting) && Objects.equals((Object)this.state, (Object)parentSoftwareVersionGetResponse.state) && Objects.equals(this.revision, parentSoftwareVersionGetResponse.revision) && Objects.equals(this.createdAt, parentSoftwareVersionGetResponse.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildNumber, this.versionNumber, this.hosting, this.state, this.revision, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParentSoftwareVersionGetResponse {\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    hosting: ").append(this.toIndentedString(this.hosting)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        DRAFT("draft"),
        ACTIVE("active"),
        ARCHIVED("archived");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum HostingEnum {
        CLOUD("cloud"),
        SERVER("server"),
        DATACENTER("datacenter");

        private String value;

        private HostingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HostingEnum fromValue(String value) {
            for (HostingEnum b : HostingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

