/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import com.atlassian.sigillo.signature.verifier.CertificateAdapter;
import com.atlassian.sigillo.signature.verifier.CertificatePrinter;
import com.atlassian.sigillo.signature.verifier.exception.CertificateIssuerNotFoundException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CertificateChainBuilder {
    private CertificateChainBuilder() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static List<X509Certificate> buildX509CertificateChain(String leafCertificate, List<String> trustedCertificates) {
        int maxChainLength;
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        X509Certificate currentCert = CertificateAdapter.pemToX509Certificate(leafCertificate);
        List<X509Certificate> trustedX509Certificate = trustedCertificates.stream().map(CertificateAdapter::pemToX509Certificate).toList();
        chain.add(currentCert);
        for (maxChainLength = 5; !CertificateChainBuilder.isSelfSigned(currentCert) && maxChainLength > 0; --maxChainLength) {
            X509Certificate finalCurrentCert = currentCert;
            X509Certificate issuerCert = CertificateChainBuilder.findIssuerCertificate(currentCert, trustedX509Certificate).orElseThrow(() -> new CertificateIssuerNotFoundException("Incomplete chain: issuer certificate not found for: " + CertificatePrinter.printCertificate(finalCurrentCert)));
            chain.add(issuerCert);
            currentCert = issuerCert;
        }
        if (maxChainLength == 0) {
            throw new CertificateIssuerNotFoundException("Incomplete chain: maximum chain length reached");
        }
        return chain;
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal());
    }

    private static Optional<X509Certificate> findIssuerCertificate(X509Certificate cert, List<X509Certificate> trustedCerts) {
        return trustedCerts.stream().filter(potentialIssuer -> Arrays.equals(cert.getIssuerX500Principal().getEncoded(), potentialIssuer.getSubjectX500Principal().getEncoded())).filter(potentialIssuer -> {
            try {
                cert.verify(potentialIssuer.getPublicKey());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst();
    }
}

