/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sigillo.signature.verifier;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bouncycastle.asn1.ASN1Integer;

class CertificatePrinter {
    private CertificatePrinter() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String printCertificate(X509Certificate cert) {
        if (cert == null) {
            return "<null>";
        }
        BigInteger serialNumber = cert.getSerialNumber();
        return MessageFormat.format("\n -subject={0}\n -sn={1}\n -issuer={2}\n -notBefore={3}\n -notAfter={4}\n -sigAlgName={5}", cert.getSubjectX500Principal(), CertificatePrinter.toHex(Optional.ofNullable(serialNumber).orElse(BigInteger.ZERO)), cert.getIssuerX500Principal(), cert.getNotAfter(), cert.getNotBefore(), cert.getSigAlgName());
    }

    public static String toHex(ASN1Integer value) {
        return CertificatePrinter.toHex(value.getValue());
    }

    public static String toHex(BigInteger value) {
        return CertificatePrinter.toHex(value.toByteArray());
    }

    public static String toHex(byte[] bytes) {
        return bytes.length == 0 ? "" : IntStream.range(0, bytes.length).mapToObj(i -> String.format("%02X", bytes[i] & 0xFF)).collect(Collectors.joining(":"));
    }
}

