/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.atlassian.upm.signing.api.PluginInstallationOrigin;
import java.util.Arrays;

public enum PluginOrigin implements PluginInstallationOrigin
{
    UPLOAD,
    DIRECTORY_SCANNER(true),
    MARKETPLACE,
    SELF_UPDATE;

    private final String propertyName = this.name().toLowerCase();
    private final boolean disabledByDefault;

    private PluginOrigin() {
        this(false);
    }

    private PluginOrigin(boolean disabledByDefault) {
        this.disabledByDefault = disabledByDefault;
    }

    public static PluginOrigin find(String origin) {
        return Arrays.stream(PluginOrigin.values()).filter(v -> v.name().equalsIgnoreCase(origin)).findFirst().orElse(null);
    }

    @Override
    public String propertyName() {
        return this.propertyName;
    }

    @Override
    public boolean disabledByDefault() {
        return this.disabledByDefault;
    }
}

