/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.atlassian.upm.signing.api.PluginSignature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSignatureReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginSignatureReader.class);
    public static final String SIGNATURE_HEADER_NAME = "X-Atlassian-Signature";
    public static final String CERTIFICATE_HEADER_NAME = "X-Atlassian-Certificate";
    private final ObjectMapper objectMapper;

    public PluginSignatureReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public PluginSignatureReader() {
        this(new ObjectMapper());
    }

    public PluginSignature readSignature(String signature) {
        if (signature == null) {
            return null;
        }
        try {
            return this.decode((PluginSignature)this.objectMapper.readValue(signature, PluginSignature.class));
        }
        catch (IOException ioe) {
            LOGGER.error("Error reading signature from {} : ", (Object)signature, (Object)ioe);
            return null;
        }
    }

    private static String readPath(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            LOGGER.error("Error reading signature from {} : ", (Object)path, (Object)e);
            return null;
        }
    }

    public PluginSignature readSignatureFromFile(Path signature) {
        return Optional.ofNullable(signature).map(PluginSignatureReader::readPath).map(this::readSignature).orElse(null);
    }

    public PluginSignature readSignatureFromHttpResponse(HttpResponse response) {
        String sig = Optional.ofNullable(response.getFirstHeader(SIGNATURE_HEADER_NAME)).map(NameValuePair::getValue).orElse(null);
        String cert = Optional.ofNullable(response.getFirstHeader(CERTIFICATE_HEADER_NAME)).map(NameValuePair::getValue).orElse(null);
        return this.decode(new PluginSignature(sig, cert));
    }

    public PluginSignature decode(PluginSignature encoded) {
        if (encoded == null) {
            return null;
        }
        return new PluginSignature(encoded.signature(), PluginSignatureReader.decodeCertificate(encoded.certificate()));
    }

    private static String decodeCertificate(String certificate) {
        if (certificate == null) {
            return null;
        }
        try {
            return new String(Base64.getDecoder().decode(certificate), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Certificate in signature is not Base64 encoded : {}", (Object)certificate);
            return certificate;
        }
    }
}

