/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.marketplace.client.impl.CommonsHttpTransport;
import com.atlassian.platform.security.file.FileMetadata;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.PluginDownloadService;
import com.atlassian.upm.core.PluginOrigin;
import com.atlassian.upm.core.PluginSignatureReader;
import com.atlassian.upm.core.impl.Uris;
import com.atlassian.upm.core.install.AccessDeniedException;
import com.atlassian.upm.core.install.InvalidFileURIException;
import com.atlassian.upm.core.install.RelativeURIException;
import com.atlassian.upm.core.install.UnsupportedProtocolException;
import com.atlassian.upm.core.pac.ClientContextFactory;
import com.atlassian.upm.core.pac.MarketplaceClientConfiguration;
import com.atlassian.upm.core.util.PluginTempFileManager;
import com.atlassian.upm.signing.api.PluginSignature;
import com.atlassian.upm.signing.api.config.UpmConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PluginDownloadServiceImpl
implements PluginDownloadService,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginDownloadServiceImpl.class);
    private static final Duration PROGRESS_TRACKER_STATUS_UPDATE_FREQUENCY = Duration.ofMillis(100L);
    private static final String[] DEFAULT_ACCEPTABLE_MEDIA_TYPES = new String[]{"application/octet-stream", "application/java-archive", "*/*"};
    private static final int CONNECTION_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 30000;
    private static final String URI_ATTR = "upm.download.uri";
    public static final int MAX_FOLLOW_REDIRECTS = 6;
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILENAME_REGEX = Pattern.compile("filename=\"([^\"]*)\"");
    public static final String INCLUDE_SIGNATURE = "includeSignature";
    private final HttpClient httpClient;
    private final ClientContextFactory clientContextFactory;
    private final PluginSignatureReader signatureReader;
    private final Function<URI, URI> downloadUriTransformer;
    private final PluginTempFileManager pluginTempFileManager;

    public PluginDownloadServiceImpl(ClientContextFactory clientContextFactory, UpmConfig upmConfig, PluginSignatureReader pluginSignatureReader, PluginTempFileManager pluginTempFileManager) {
        this.clientContextFactory = Objects.requireNonNull(clientContextFactory, "clientContextFactory");
        this.signatureReader = pluginSignatureReader;
        this.downloadUriTransformer = uri -> PluginDownloadServiceImpl.addSignatureRequestParam(upmConfig, uri);
        this.httpClient = this.buildClient(this.downloadUriTransformer);
        this.pluginTempFileManager = Objects.requireNonNull(pluginTempFileManager, "PluginTeempFileManager");
    }

    HttpClient buildClient(Function<URI, URI> downloadUriTransformer) {
        HttpConfiguration config = MarketplaceClientConfiguration.httpConfigurationFromSystemProperties().connectTimeoutMillis(30000).readTimeoutMillis(30000).maxRedirects(UpmFugueConverters.fugueSome(6)).build();
        return CommonsHttpTransport.httpClientBuilder(config, UpmFugueConverters.fugueNone(URI.class), CommonsHttpTransport.CachingBehavior.NO_CACHING).setRedirectStrategy((RedirectStrategy)new DownloadRedirectStrategy(downloadUriTransformer)).build();
    }

    @Override
    public PluginDownloadService.DownloadResult downloadPlugin(URI uri, Option<String> displayName, PluginDownloadService.ProgressTracker progressTracker) throws ResponseException, FileNotFoundException {
        return this.downloadPlugin(uri, displayName, Option.none(String[].class), progressTracker);
    }

    @Override
    public PluginDownloadService.DownloadResult downloadPlugin(URI uri, Option<String> displayName, String[] acceptHeaders, PluginDownloadService.ProgressTracker progressTracker) throws ResponseException, FileNotFoundException {
        return this.downloadPlugin(uri, displayName, Option.some(acceptHeaders), progressTracker);
    }

    public void destroy() throws Exception {
        if (this.httpClient instanceof Closeable) {
            ((Closeable)this.httpClient).close();
        }
    }

    private static URI addSignatureRequestParam(UpmConfig upmConfig, URI uri) {
        if (Uris.isFromMpac(uri) && upmConfig.isPluginSigningEnabled(PluginOrigin.MARKETPLACE)) {
            try {
                URIBuilder builder = new URIBuilder(uri);
                builder.addParameter(INCLUDE_SIGNATURE, "true");
                return builder.build();
            }
            catch (URISyntaxException e) {
                return uri;
            }
        }
        return uri;
    }

    private PluginDownloadService.DownloadResult downloadPlugin(URI uri, Option<String> displayName, Option<String[]> acceptHeaders, PluginDownloadService.ProgressTracker progressTracker) throws ResponseException, FileNotFoundException {
        log.info("Downloading plugin artifact from [" + String.valueOf(uri) + "]...");
        PluginDownloadServiceImpl.checkIfURIIsSupported(uri);
        if (Uris.hasFileScheme(uri)) {
            File pluginFile = PluginDownloadServiceImpl.readLocalFile(uri);
            return new PluginDownloadService.DownloadResult(pluginFile, displayName.getOrElse(pluginFile.getName()), Option.none(String.class));
        }
        return this.download(uri, acceptHeaders, progressTracker, displayName);
    }

    @NotNull
    private static File readLocalFile(URI uri) throws FileNotFoundException, AccessDeniedException, InvalidFileURIException {
        try {
            File f = new File(uri);
            if (!f.exists() || !f.isFile()) {
                throw new FileNotFoundException(f.getName() + " is not a valid file");
            }
            if (!f.canRead()) {
                throw new AccessDeniedException("Cannot read " + f.getName());
            }
            return f;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidFileURIException(String.valueOf(uri) + " is not a valid download URI");
        }
    }

    private void consumeResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private PluginDownloadService.DownloadResult download(URI uri, Option<String[]> acceptHeaders, PluginDownloadService.ProgressTracker progressTracker, Option<String> displayName) throws ResponseException {
        Option<String> acceptHeader = acceptHeaders.flatMap(headers -> Option.some(StringUtils.join((Object[])headers, ", ")));
        HttpGet method = new HttpGet(this.downloadUriTransformer.apply(uri));
        method.addHeader("X-Pac-Client-Info", this.clientContextFactory.getClientContext().toString());
        method.addHeader("Accept", (String)acceptHeader.getOrElse(StringUtils.join((Object[])DEFAULT_ACCEPTABLE_MEDIA_TYPES, ", ")));
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute(URI_ATTR, (Object)uri);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)context);
            URI newUri = (URI)context.getAttribute(URI_ATTR);
            if (!uri.equals(newUri)) {
                progressTracker.redirectedTo(newUri);
            }
            if (response.getStatusLine().getStatusCode() == 401) {
                this.consumeResponse(response);
                throw new AccessDeniedException("Requires Authorization.");
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                String message = response.getStatusLine().getStatusCode() + " " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                this.consumeResponse(response);
                throw new ResponseException("Failed to download plugin: " + message);
            }
            newUri = (URI)context.getAttribute(URI_ATTR);
            String fileName = this.coerceFileExtensionForContentType(this.getFileNameFromResponse(response, newUri), response);
            PluginSignature signature = this.signatureReader.readSignatureFromHttpResponse(response);
            Long contentLength = Optional.ofNullable(response.getLastHeader("Content-Length")).map(h -> Long.parseLong(h.getValue())).orElse(-1L);
            String contentType = Optional.ofNullable(response.getLastHeader("Content-Type")).map(NameValuePair::getValue).orElse(null);
            LongFunction<ZonedDateTime> progressUpdater = count -> {
                progressTracker.notify(new PluginDownloadService.Progress(count, contentLength, displayName.orElse(Option.some(fileName))));
                return ZonedDateTime.now().plus(PROGRESS_TRACKER_STATUS_UPDATE_FREQUENCY);
            };
            FileMetadata metadata = new FileMetadata(fileName, contentLength.longValue(), contentType);
            File pluginFile = this.pluginTempFileManager.copyPluginToTemporaryFile(metadata, () -> response.getEntity().getContent(), progressUpdater);
            PluginDownloadService.DownloadResult downloadResult = new PluginDownloadService.DownloadResult(pluginFile, signature, displayName.getOrElse(fileName), this.getContentTypeFromResponse(response));
            return downloadResult;
        }
        catch (IOException ioe) {
            throw new ResponseException(ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getFileNameFromResponse(HttpResponse response, URI uri) {
        Matcher filenameMatcher;
        Header contentDispositionHeader = response.getLastHeader(CONTENT_DISPOSITION);
        if (contentDispositionHeader != null && (filenameMatcher = CONTENT_DISPOSITION_FILENAME_REGEX.matcher(contentDispositionHeader.getValue())).find()) {
            return filenameMatcher.group(1);
        }
        String path = uri.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private Option<String> getContentTypeFromResponse(HttpResponse response) {
        Header h = response.getEntity().getContentType();
        return h == null ? Option.none(String.class) : Option.option(h.getValue());
    }

    private String coerceFileExtensionForContentType(String filename, HttpResponse response) {
        Header contentTypeHeader = response.getLastHeader("Content-Type");
        if (contentTypeHeader != null) {
            String contentType = contentTypeHeader.getValue().toLowerCase();
            if (contentType.contains(";")) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            if (contentType.equals("application/java-archive")) {
                return this.coerceFileExtension(filename, "jar");
            }
            if (contentType.endsWith("/xml")) {
                return this.coerceFileExtension(filename, "xml");
            }
        }
        return filename;
    }

    private String coerceFileExtension(String filename, String extension) {
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf(".") + 1) + extension;
        }
        return filename + "." + extension;
    }

    private static void checkIfURIIsSupported(URI uri) throws ResponseException {
        if (!uri.isAbsolute()) {
            throw new RelativeURIException("URI must be absolute");
        }
        if (!(Uris.hasHttpScheme(uri) || Uris.hasHttpsScheme(uri) || Uris.hasFileScheme(uri))) {
            throw new UnsupportedProtocolException("URI scheme '" + uri.getScheme() + "' is not supported");
        }
        if (Uris.hasFileScheme(uri) && (uri.getPath() == null || uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null)) {
            throw new InvalidFileURIException("URI is not a valid download URI");
        }
    }

    private static class DownloadRedirectStrategy
    extends DefaultRedirectStrategy {
        private final Function<URI, URI> locationURITransformer;

        private DownloadRedirectStrategy(Function<URI, URI> locationURITransformer) {
            this.locationURITransformer = locationURITransformer;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            HttpUriRequest method = super.getRedirect(request, response, context);
            try {
                PluginDownloadServiceImpl.checkIfURIIsSupported(method.getURI());
            }
            catch (ResponseException e) {
                throw new ProtocolException(e.getMessage());
            }
            context.setAttribute(PluginDownloadServiceImpl.URI_ATTR, (Object)method.getURI());
            method.removeHeaders("X-Pac-Client-Info");
            method.addHeader("Accept", StringUtils.join((Object[])DEFAULT_ACCEPTABLE_MEDIA_TYPES, ", "));
            return method;
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            return switch (response.getStatusLine().getStatusCode()) {
                case 301, 302 -> true;
                default -> false;
            };
        }

        public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return this.locationURITransformer.apply(super.getLocationURI(request, response, context));
        }
    }
}

