/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.policy;

import com.atlassian.upm.core.PluginOrigin;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.policy.PolicyException;
import com.atlassian.upm.signing.api.config.UpmConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEnforcer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyEnforcer.class);
    private final URI mpacBaseUrl;
    private final Supplier<Boolean> pluginUploadEnabledSupplier;
    private final UpmConfig upmConfig;
    private final AtomicBoolean wasSignatureCheckEnabledOnUpload = new AtomicBoolean();
    private static final String PLUGIN_UPLOAD_ENABLED_PROP = "upm.plugin.upload.enabled";

    public PolicyEnforcer(UpmConfig upmConfig) {
        try {
            this.mpacBaseUrl = new URI(Sys.getMpacBaseUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse MPAC base URL", e);
        }
        this.upmConfig = upmConfig;
        if (Sys.isDevModeEnabled()) {
            this.pluginUploadEnabledSupplier = () -> true;
        } else if (Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(PLUGIN_UPLOAD_ENABLED_PROP))) {
            this.pluginUploadEnabledSupplier = () -> false;
        } else {
            boolean explicitelyEnabled = Boolean.getBoolean(PLUGIN_UPLOAD_ENABLED_PROP);
            this.wasSignatureCheckEnabledOnUpload.set(this.isSignatureCheckEnabledOnUpload());
            if (explicitelyEnabled && !this.wasSignatureCheckEnabledOnUpload.get()) {
                this.logUploadEnabledWarning();
            }
            this.pluginUploadEnabledSupplier = () -> {
                boolean isSignatureCheckEnabledOnUpload = this.isSignatureCheckEnabledOnUpload();
                if (explicitelyEnabled && !isSignatureCheckEnabledOnUpload && this.wasSignatureCheckEnabledOnUpload.get()) {
                    this.logUploadEnabledWarning();
                }
                this.wasSignatureCheckEnabledOnUpload.set(isSignatureCheckEnabledOnUpload);
                return explicitelyEnabled || isSignatureCheckEnabledOnUpload;
            };
        }
    }

    private void logUploadEnabledWarning() {
        LOGGER.warn("PluginUpload is enabled but plugin signature check is disabled!");
    }

    public void checkCanInstallPluginByUpload() {
        if (!this.isPluginUploadEnabled()) {
            throw new PolicyException("Plugins cannot be installed via upload");
        }
    }

    public void checkCanInstallPluginFromUri(URI uri) {
        if (!this.isMpacUri(uri) && !this.isPluginUploadEnabled()) {
            throw new PolicyException("Plugins can only be installed from Atlassian Marketplace");
        }
    }

    public boolean isPluginUploadEnabled() {
        return this.pluginUploadEnabledSupplier.get();
    }

    private boolean isMpacUri(URI uri) {
        return this.mpacBaseUrl.getScheme().equals(uri.getScheme()) && this.mpacBaseUrl.getHost().equalsIgnoreCase(uri.getHost()) && uri.getPath().startsWith(this.mpacBaseUrl.getPath());
    }

    public boolean isSignatureCheckEnabledOnUpload() {
        return this.upmConfig.isPluginSigningEnabled(PluginOrigin.UPLOAD);
    }

    public PluginOrigin resolvePluginOriginMatchingUri(URI uri, PluginOrigin pluginOrigin) {
        if (pluginOrigin == null) {
            if (this.isMpacUri(uri)) {
                return PluginOrigin.MARKETPLACE;
            }
            return PluginOrigin.UPLOAD;
        }
        switch (pluginOrigin) {
            case MARKETPLACE: {
                if (this.isMpacUri(uri)) break;
                throw new PolicyException("Plugin was not downloaded from Marketplace");
            }
            case UPLOAD: {
                if (!this.isMpacUri(uri)) break;
                LOGGER.warn("Uploading a Marketplace plugin from the UI");
                break;
            }
            default: {
                throw new PolicyException("Plugin Origin does not require a URI");
            }
        }
        return pluginOrigin;
    }
}

