/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.representations;

import com.atlassian.plugins.rest.api.model.Status;
import com.atlassian.upm.core.rest.representations.BaseRepresentationFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ErrorResponseStatusObjectMapper
extends ObjectMapper {
    private final BaseRepresentationFactory representationFactory;

    public ErrorResponseStatusObjectMapper(BaseRepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
        SimpleModule module = new SimpleModule();
        module.addSerializer(Status.class, (JsonSerializer)new StatusToErrorRepresentationSerializer());
        this.registerModule((Module)module);
    }

    private final class StatusToErrorRepresentationSerializer
    extends JsonSerializer<Status> {
        private StatusToErrorRepresentationSerializer() {
        }

        public void serialize(Status value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (StringUtils.isEmpty(value.getMessage())) {
                jgen.writeObject((Object)ErrorResponseStatusObjectMapper.this.representationFactory.createI18nErrorRepresentation("upm.plugin.error.unexpected.error"));
            } else {
                jgen.writeObject((Object)ErrorResponseStatusObjectMapper.this.representationFactory.createErrorRepresentation(value.getMessage(), "upm.plugin.error.unexpected.error"));
            }
        }
    }
}

