/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.upm.core.Change;
import com.atlassian.upm.core.PluginRestartRequiredService;
import com.atlassian.upm.core.rest.representations.BasePluginRepresentationFactory;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@LicensedOnly
@Path(value="/requires-restart")
public class ChangeRequiringRestartCollectionResource {
    private final BasePluginRepresentationFactory factory;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRestartRequiredService restartRequiredService;

    @Inject
    public ChangeRequiringRestartCollectionResource(PluginRestartRequiredService restartRequiredService, BasePluginRepresentationFactory factory, PermissionEnforcer permissionEnforcer) {
        this.restartRequiredService = Objects.requireNonNull(restartRequiredService, "restartRequiredService");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.factory = Objects.requireNonNull(factory, "factory");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.changes.requiring.restart+json"})
    public Response get() {
        Iterable filteredChanges = Iterables.filter(this.restartRequiredService.getRestartRequiredChanges(), (Predicate)new Predicate<Change>(){

            public boolean apply(Change change) {
                return ChangeRequiringRestartCollectionResource.this.permissionEnforcer.hasPermission(change.getRequiredPermission());
            }
        });
        return Response.ok((Object)this.factory.createChangesRequiringRestartRepresentation(filteredChanges)).build();
    }
}

