/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginEnablementService;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.permission.PermissionService;
import com.atlassian.upm.core.rest.PluginRestUninstaller;
import com.atlassian.upm.core.rest.UpmUriEscaper;
import com.atlassian.upm.core.rest.representations.BasePluginRepresentationFactory;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;

@AdminOnly
@Path(value="/{pluginKey}")
public class PluginResource {
    private final BasePluginRepresentationFactory representationFactory;
    private final I18nResolver i18nResolver;
    private final PluginEnablementService enabler;
    private final PluginRetriever pluginRetriever;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRestUninstaller restUninstaller;
    private final PluginMetadataAccessor pluginMetadataAccessor;
    private final ApplicationPluginsManager applicationPluginsManager;

    @Inject
    public PluginResource(BasePluginRepresentationFactory representationFactory, I18nResolver i18nResolver, PluginEnablementService enabler, PluginRetriever pluginRetriever, PermissionEnforcer permissionEnforcer, PluginRestUninstaller restUninstaller, PluginMetadataAccessor pluginMetadataAccessor, ApplicationPluginsManager applicationPluginsManager) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.i18nResolver = Objects.requireNonNull(i18nResolver, "i18nResolver");
        this.enabler = Objects.requireNonNull(enabler, "enabler");
        this.pluginRetriever = Objects.requireNonNull(pluginRetriever, "pluginRetriever");
        this.restUninstaller = Objects.requireNonNull(restUninstaller, "restUninstaller");
        this.pluginMetadataAccessor = Objects.requireNonNull(pluginMetadataAccessor, "pluginMetadataAccessor");
        this.applicationPluginsManager = Objects.requireNonNull(applicationPluginsManager, "applicationPluginsManager");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.plugin+json"})
    public Response get(@PathParam(value="pluginKey") PathSegment pluginKeyPath) {
        this.permissionEnforcer.enforcePermission(Permission.GET_INSTALLED_PLUGINS);
        String pluginKey = UpmUriEscaper.unescape(pluginKeyPath.getPath());
        Iterator<Plugin> iterator = this.pluginRetriever.getPlugin(pluginKey).iterator();
        if (iterator.hasNext()) {
            Plugin plugin = iterator.next();
            return Response.ok((Object)this.representationFactory.createPluginRepresentation(plugin)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins.plugin+json"})
    public Response put(@PathParam(value="pluginKey") PathSegment pluginKeyPath, PluginUpdateRepresentation updateRepresentation) {
        String pluginKey = UpmUriEscaper.unescape(pluginKeyPath.getPath());
        for (Plugin plugin : this.pluginRetriever.getPlugin(pluginKey)) {
            Iterator<Plugin> iterator;
            this.permissionEnforcer.enforcePermission(Permission.MANAGE_PLUGIN_ENABLEMENT, plugin);
            if (plugin.isUpmPlugin()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.plugin.error.invalid.upm.plugin.action")).type("application/vnd.atl.plugins.error+json").build();
            }
            if (this.pluginRetriever.isPluginEnabled(pluginKey) != updateRepresentation.isEnabled().booleanValue()) {
                if (updateRepresentation.isEnabled().booleanValue()) {
                    if (!this.enabler.enablePlugin(pluginKey)) {
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.representationFactory.createErrorRepresentation(this.i18nResolver.getText("upm.plugin.error.failed.to.enable"), "upm.plugin.error.failed.to.enable")).type("application/vnd.atl.plugins.error+json").build();
                    }
                } else {
                    if (!this.pluginMetadataAccessor.isOptional(plugin)) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createErrorRepresentation(this.i18nResolver.getText("upm.plugin.error.failed.to.disable.system.plugin"), "upm.plugin.error.failed.to.disable.system.plugin")).type("application/vnd.atl.plugins.error+json").build();
                    }
                    if (this.applicationPluginsManager.getApplicationRelatedPluginKeys().contains(plugin.getKey())) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createErrorRepresentation(this.i18nResolver.getText("upm.plugin.error.failed.to.disable.application.component"), "upm.plugin.error.failed.to.disable.application.component")).type("application/vnd.atl.plugins.error+json").build();
                    }
                    if (!this.enabler.disablePlugin(pluginKey)) {
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.representationFactory.createErrorRepresentation(this.i18nResolver.getText("upm.plugin.error.failed.to.disable"), "upm.plugin.error.failed.to.disable")).type("application/vnd.atl.plugins.error+json").build();
                    }
                }
            }
            if (!(iterator = this.pluginRetriever.getPlugin(pluginKey).iterator()).hasNext()) continue;
            Plugin updatedPlugin = iterator.next();
            return Response.ok((Object)this.representationFactory.createPluginRepresentation(updatedPlugin)).type("application/vnd.atl.plugins.plugin+json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    public Response uninstallPlugin(@PathParam(value="pluginKey") PathSegment pluginKeyPath) {
        String pluginKey = UpmUriEscaper.unescape(pluginKeyPath.getPath());
        Option<Plugin> maybePlugin = this.pluginRetriever.getPlugin(pluginKey);
        Iterator<Plugin> iterator = maybePlugin.iterator();
        if (iterator.hasNext()) {
            Plugin plugin = iterator.next();
            Iterator<PluginRestUninstaller.UninstallError> iterator2 = this.restUninstaller.uninstall(plugin).iterator();
            if (iterator2.hasNext()) {
                PluginRestUninstaller.UninstallError error = iterator2.next();
                for (PermissionService.PermissionError permError : error.getPermissionError()) {
                    this.permissionEnforcer.handleError(permError);
                }
                if (error.getType() == PluginRestUninstaller.UninstallError.Type.REQUIRES_RESTART) {
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)this.representationFactory.createPluginRepresentation(error.getPlugin())).type("application/vnd.atl.plugins.plugin+json").build();
                }
                String code = error.getType().getErrorCode();
                return Response.status((Response.Status)(switch (error.getType()) {
                    case PluginRestUninstaller.UninstallError.Type.PLUGIN_IS_UPM -> Response.Status.fromStatusCode((int)405);
                    case PluginRestUninstaller.UninstallError.Type.SAFE_MODE -> Response.Status.CONFLICT;
                    default -> Response.Status.FORBIDDEN;
                })).type("application/vnd.atl.plugins.error+json").entity((Object)this.representationFactory.createErrorRepresentation(this.i18nResolver.getText(code, new Serializable[]{plugin.getName()}), code)).build();
            }
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static final class PluginUpdateRepresentation {
        @JsonProperty
        private Boolean enabled;

        @JsonCreator
        public PluginUpdateRepresentation(@JsonProperty(value="enabled") Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }
    }
}

