/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources.install;

import com.atlassian.platform.security.file.FileMetadata;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.util.Either;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.PluginInstallationService;
import com.atlassian.upm.core.PluginOrigin;
import com.atlassian.upm.core.SelfUpdateController;
import com.atlassian.upm.core.async.AsyncTaskStage;
import com.atlassian.upm.core.async.AsyncTaskStatus;
import com.atlassian.upm.core.async.AsyncTaskStatusUpdater;
import com.atlassian.upm.core.install.FileTooLargeException;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.atlassian.upm.core.rest.resources.install.InstallTask;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.util.PluginTempFileManager;
import com.atlassian.upm.impl.FileUtil;
import com.atlassian.upm.signing.api.PluginSignature;
import java.io.File;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallFromFileUploadTask
extends InstallTask {
    private static final Logger logger = LoggerFactory.getLogger(InstallFromFileUploadTask.class);
    private final PermissionEnforcer permissionEnforcer;
    private final PluginSignature pluginSignature;
    private final FilePart pluginPart;
    private final String name;
    private final PluginTempFileManager pluginTempFileManager;
    private final AuditLogService auditLogger;

    public InstallFromFileUploadTask(FilePart pluginPart, String type, PluginSignature signature, PluginInstallationService pluginInstaller, SelfUpdateController selfUpdateController, BaseUriBuilder uriBuilder, ApplicationPluginsManager applicationPluginsManager, I18nResolver i18nResolver, PluginTempFileManager pluginTempFileManager, PermissionEnforcer permissionEnforcer, AuditLogService auditLogger) {
        super(Option.option(pluginPart.getName()), pluginInstaller, selfUpdateController, uriBuilder, applicationPluginsManager, i18nResolver);
        this.pluginPart = pluginPart;
        this.name = InstallFromFileUploadTask.getFileName(pluginPart.getName(), type);
        this.pluginSignature = signature;
        this.pluginTempFileManager = pluginTempFileManager;
        this.permissionEnforcer = permissionEnforcer;
        this.auditLogger = Objects.requireNonNull(auditLogger, "auditLogger");
    }

    @Override
    protected AsyncTaskStatus executeTask(AsyncTaskStatusUpdater statusUpdater) throws Exception {
        return this.upload(statusUpdater).fold(Function.identity(), uploaded -> this.installFromFile((File)uploaded, this.pluginSignature, this.name, Option.none(String.class), this.getInitialStatus(), statusUpdater));
    }

    private Either<AsyncTaskStatus, File> upload(AsyncTaskStatusUpdater statusUpdater) {
        try {
            this.permissionEnforcer.enforcePermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_FILE);
            FileMetadata metadata = new FileMetadata(this.name, this.pluginPart.getSize(), this.pluginPart.getContentType());
            File pluginFile = this.pluginTempFileManager.copyPluginToTemporaryFile(metadata, () -> ((FilePart)this.pluginPart).getInputStream(), count -> ZonedDateTime.now());
            return Either.right(pluginFile);
        }
        catch (FileTooLargeException e) {
            logger.error("File is too large " + this.getSource());
            this.auditLogger.logI18nMessage("upm.auditLog.install.plugin.file.too.large", this.getSource());
            return Either.left(this.errBySubcode("upm.pluginInstall.error.file.too.large"));
        }
        catch (Exception e) {
            this.logUnexpectedError(this.name, e, statusUpdater);
            return Either.left(this.errBySubcode("unexpected.exception"));
        }
    }

    @Override
    protected PluginOrigin getPluginOrigin() {
        return PluginOrigin.UPLOAD;
    }

    @Override
    public AsyncTaskStatus getInitialStatus() {
        return AsyncTaskStatus.builder().stage(Option.some(AsyncTaskStage.INSTALLING)).resourceName(Option.option(this.pluginPart.getName())).build();
    }

    private static String getFileName(String name, String type) {
        if (name == null) {
            return "plugin." + type;
        }
        String[] paths = name.split("[\\\\|/]");
        return FileUtil.sanitizeFileName(paths[paths.length - 1]);
    }

    private void logUnexpectedError(String name, Exception e, AsyncTaskStatusUpdater statusUpdater) {
        statusUpdater.updateStatus(this.errBySubcode("upm.plugin.error.unexpected.error"));
        logger.error("Failed to install plugin", (Throwable)e);
        this.auditLogger.logI18nMessage("upm.auditLog.install.plugin.failure", this.getSource(), name, e.getMessage());
    }
}

