/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/test/active-edition")
public class ActiveEditionResource {
    private final PermissionEnforcer permissionEnforcer;
    private static volatile ActiveEditionRepresentation edition = null;

    @Inject
    public ActiveEditionResource(PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    public Response set(ActiveEditionRepresentation rep) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        edition = rep;
        return Response.ok((Object)rep).type("application/vnd.atl.plugins+json").build();
    }

    @DELETE
    public Response reset() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        edition = null;
        return Response.ok().build();
    }

    public static Option<Integer> getActiveEdition() {
        if (edition != null) {
            return Option.some(ActiveEditionResource.edition.edition);
        }
        return Option.none();
    }

    public static final class ActiveEditionRepresentation {
        @JsonProperty
        private Integer edition;

        @JsonCreator
        public ActiveEditionRepresentation(@JsonProperty(value="edition") Integer edition) {
            this.edition = edition;
        }

        public Integer getEdition() {
            return this.edition;
        }
    }
}

