/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.util;

import com.atlassian.platform.security.PathTraversalChecker;
import com.atlassian.platform.security.file.FileMetadata;
import com.atlassian.platform.security.file.FileSafetyChecker;
import com.atlassian.platform.security.file.FileValidationError;
import com.atlassian.upm.core.install.FileTooLargeException;
import com.atlassian.upm.core.install.FileUploadException;
import com.atlassian.upm.core.install.ForbiddenFileNameException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTempFileManager {
    private static final String DL_PLUGIN_FILE_PREFIX = "plugin.";
    private static final int DL_PLUGIN_FILE_SUFFIX_MAX_SIZE = 60;
    private static final int DOWNLOAD_BUFFER_SIZE = 4096;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)([kMG]?)");
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginTempFileManager.class);
    private final long maxFileSize;

    public PluginTempFileManager(String maxFileSize) {
        this.maxFileSize = PluginTempFileManager.getMaxFileSize(maxFileSize).orElse(0L);
    }

    public PluginTempFileManager() {
        this(null);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    private static Optional<Long> getMaxFileSize(String value) {
        if (value != null) {
            Matcher matcher = FILE_SIZE_PATTERN.matcher(value);
            if (matcher.matches()) {
                long size = Integer.parseInt(matcher.group(1));
                long multiplier = switch (matcher.group(2)) {
                    case "k" -> 1024L;
                    case "M" -> 0x100000L;
                    case "G" -> 0x40000000L;
                    default -> 1L;
                };
                return Optional.of(size * multiplier);
            }
            LOGGER.warn("UPM configuration error : {} was not recognized as a file size", (Object)value);
        }
        return Optional.empty();
    }

    public File copyPluginToTemporaryFile(FileMetadata fileMetadata, InputStreamSupplier inputStreamSupplier, LongFunction<ZonedDateTime> updater) throws IOException, FileUploadException {
        Collection errors = FileSafetyChecker.validateBeforeUpload((FileMetadata)fileMetadata, (long)this.maxFileSize, (boolean)true, List.of());
        if (!errors.isEmpty()) {
            if (errors.stream().anyMatch(error -> error.type() == FileValidationError.Type.TOO_LARGE)) {
                throw new FileTooLargeException("File is too large : " + fileMetadata.fileName());
            }
            if (errors.stream().anyMatch(error -> error.type() == FileValidationError.Type.NAME_TOO_LONG)) {
                throw new ForbiddenFileNameException("Too long file name ");
            }
            throw new ForbiddenFileNameException("Forbidden character in file name " + fileMetadata.fileName());
        }
        File plugin = this.createTempFile(fileMetadata.fileName());
        if (PathTraversalChecker.isSafePath((Path)plugin.toPath())) {
            throw new ForbiddenFileNameException("Forbidden character in file name " + String.valueOf(plugin.toPath()));
        }
        try (InputStream in = inputStreamSupplier.getInputStream();
             FileOutputStream out = FileUtils.openOutputStream((File)plugin);){
            this.copy(fileMetadata.fileName(), in, out, updater);
        }
        return plugin;
    }

    private boolean isFileTooLarge(long size) {
        return this.maxFileSize > 0L && size > this.maxFileSize;
    }

    private File createTempFile(String filename) throws IOException {
        Object suffix = filename;
        if (filename.length() > 60) {
            int extIndex = filename.lastIndexOf(".");
            String extension = extIndex == -1 ? "" : filename.substring(extIndex);
            suffix = filename.substring(0, 60) + extension;
        }
        return File.createTempFile(DL_PLUGIN_FILE_PREFIX, "." + (String)suffix);
    }

    private void copy(String fileName, InputStream in, OutputStream out, LongFunction<ZonedDateTime> updater) throws FileTooLargeException, IOException {
        int n;
        ZonedDateTime nextUpdate = ZonedDateTime.now();
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            if (this.isFileTooLarge(count += (long)n)) {
                throw new FileTooLargeException("File is too large : " + fileName);
            }
            if (!nextUpdate.isBefore(ZonedDateTime.now())) continue;
            nextUpdate = updater.apply(count);
        }
    }

    public static interface InputStreamSupplier {
        public InputStream getInputStream() throws IOException;
    }
}

