/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Arrays;

public class UriBuilderUtil {
    public static String createUriWithFragment(HttpServletRequest request) {
        UriBuilder builder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        Object[] fragmentParts = new String[]{};
        for (Object keyObject : request.getParameterMap().keySet()) {
            String key = keyObject.toString();
            if ("fragment".equals(key)) {
                fragmentParts = UriBuilderUtil.splitFragments(request.getParameter("fragment"));
                builder.fragment(UriBuilderUtil.createFragmentTemplate(fragmentParts.length));
                continue;
            }
            builder.queryParam(key, new Object[]{request.getParameter(key)});
        }
        return builder.build(fragmentParts).toASCIIString();
    }

    private static String[] splitFragments(String fragment) {
        return (String[])Arrays.stream(fragment.split("/")).filter(s -> s != null && !s.isEmpty()).toArray(String[]::new);
    }

    private static String createFragmentTemplate(int fragmentsNumber) {
        StringBuilder fragmentTemplate = new StringBuilder("{arg0}");
        for (int i = 1; i < fragmentsNumber; ++i) {
            fragmentTemplate.append("/{arg").append(i).append("}");
        }
        return fragmentTemplate.toString();
    }
}

