/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.upm.api.util.Option;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static <T> Optional<T> toOptional(Option<T> option) {
        if (option.isDefined()) {
            return Optional.of(option.get());
        }
        return Optional.empty();
    }

    @Deprecated
    public static <T> Option<T> toOption(Optional<T> optional) {
        if (optional.isPresent()) {
            return Option.some(optional.get());
        }
        return Option.none();
    }

    public static ZonedDateTime dateToZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime parseZonedDatetime(String dateString, DateTimeFormatter dateTimeFormatter) {
        ZonedDateTime parsedDateTime = DateUtil.tryParseZonedDateTime(dateString, dateTimeFormatter);
        if (parsedDateTime == null) {
            parsedDateTime = DateUtil.tryParseLocalDateTime(dateString, dateTimeFormatter);
        }
        if (parsedDateTime == null) {
            parsedDateTime = DateUtil.tryParseLocalDate(dateString, dateTimeFormatter);
        }
        if (parsedDateTime == null) {
            log.warn("Invalid Date of \"" + dateString + "\"");
        }
        return parsedDateTime;
    }

    private static ZonedDateTime tryParseZonedDateTime(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            return ZonedDateTime.parse(dateString, dateTimeFormatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as ZonedDateTime \"" + dateString + "\"");
            return null;
        }
    }

    private static ZonedDateTime tryParseLocalDateTime(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(dateString, dateTimeFormatter);
            return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as LocalDateTime \"" + dateString + "\"");
            return null;
        }
    }

    private static ZonedDateTime tryParseLocalDate(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            LocalDate localDate = LocalDate.parse(dateString, dateTimeFormatter);
            return localDate.atStartOfDay(ZoneId.systemDefault());
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as LocalDate \"" + dateString + "\"");
            return null;
        }
    }
}

