/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl.certificates;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.impl.certificates.CertificatesProvider;
import com.atlassian.upm.signing.api.Certificate;
import com.atlassian.upm.signing.api.config.UpmConfig;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import com.atlassian.upm.signing.healthcheck.api.CertificateStatus;
import com.atlassian.upm.signing.healthcheck.api.CertificateStorageHealthStatus;
import com.atlassian.upm.signing.healthcheck.api.CertificatesHealthCheckService;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesHealthCheckServiceImpl
implements CertificatesHealthCheckService {
    private static final Logger log = LoggerFactory.getLogger(CertificatesHealthCheckServiceImpl.class);
    public final UpmConfig upmConfig;
    private final CertificatesProvider certificatesProvider;
    private final CertificateFactory certificateFactory;
    private final I18nResolver i18nResolver;

    public CertificatesHealthCheckServiceImpl(UpmConfig upmConfig, CertificatesProvider certificatesProvider, I18nResolver i18nResolver) throws CertificateException {
        this.upmConfig = upmConfig;
        this.certificatesProvider = certificatesProvider;
        this.certificateFactory = Objects.requireNonNull(CertificateFactory.getInstance("X.509"));
        this.i18nResolver = i18nResolver;
    }

    @Override
    public boolean isSignatureCheckEnabled() {
        return this.upmConfig.isPluginSigningEnabled();
    }

    @Override
    public CertificateStorageHealthStatus getCertificatesStorageHealthStatus() {
        if (!this.upmConfig.hasTruststore()) {
            return new CertificateStorageHealthStatus(CertificateStorageHealthStatus.Status.WARNING, this.i18nResolver.getText("upm.config.check.truststore.absent"));
        }
        UpmConfigStatus upmConfigStatus = this.upmConfig.safetyCheckStatus();
        if (upmConfigStatus.success() && this.certificatesProvider.getCertificates().isEmpty()) {
            return new CertificateStorageHealthStatus(CertificateStorageHealthStatus.Status.WARNING, this.i18nResolver.getText("upm.config.check.truststore.empty"));
        }
        return new CertificateStorageHealthStatus(this.mapStatus(upmConfigStatus.status()), this.i18nResolver.getText(upmConfigStatus.getI18nKey()));
    }

    private CertificateStorageHealthStatus.Status mapStatus(UpmConfigStatus.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case UpmConfigStatus.Status.SUCCESS -> CertificateStorageHealthStatus.Status.SUCCESS;
            case UpmConfigStatus.Status.WARNING -> CertificateStorageHealthStatus.Status.WARNING;
            case UpmConfigStatus.Status.FAILURE -> CertificateStorageHealthStatus.Status.FAILURE;
        };
    }

    @Override
    public List<CertificateStatus> getCertificatesExpiringWithin(int days) {
        return Optional.ofNullable(this.certificatesProvider.getCertificates()).map(certificates -> certificates.stream().map(this::mapToCertificateStatus).filter(Objects::nonNull).filter(certificateStatus -> certificateStatus.getDaysUntilExpiry() <= days).toList()).orElse(Collections.emptyList());
    }

    private CertificateStatus mapToCertificateStatus(Certificate certificate) {
        X509Certificate cert;
        String certifitateContent = certificate.content();
        certifitateContent = certifitateContent.replace("-----BEGIN CERTIFICATE-----", "");
        certifitateContent = certifitateContent.replace("-----END CERTIFICATE-----", "");
        certifitateContent = certifitateContent.replaceAll("\\s+", "");
        byte[] certificateData = Base64.getDecoder().decode(certifitateContent);
        try {
            cert = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(certificateData));
        }
        catch (CertificateException e) {
            log.error("Failed to parse certificate", (Throwable)e);
            return null;
        }
        int daysUntilExpiry = (int)((cert.getNotAfter().getTime() - System.currentTimeMillis()) / 86400000L);
        return new CertificateStatus(cert.getSubjectX500Principal().getName(), daysUntilExpiry, daysUntilExpiry < 0);
    }
}

