/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mac;

import com.atlassian.upm.impl.DateUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HamletLicenseInfo {
    private static final Logger log = LoggerFactory.getLogger(HamletLicenseInfo.class);
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    @JsonProperty
    private final String key;
    @JsonProperty
    private final String license;
    @JsonProperty
    private final String date;
    @JsonProperty
    private final String purchaser;
    @JsonIgnore
    private final Optional<ZonedDateTime> parsedDate;

    @JsonCreator
    public HamletLicenseInfo(@JsonProperty(value="key") String key, @JsonProperty(value="license") String license, @JsonProperty(value="date") String date, @JsonProperty(value="purchaser") String purchaser) {
        this.key = key;
        this.license = license;
        this.date = date;
        this.purchaser = purchaser;
        this.parsedDate = Optional.ofNullable(DateUtil.parseZonedDatetime(date, DATE_FORMATTER));
    }

    public String getKey() {
        return this.key;
    }

    public String getLicense() {
        return this.license;
    }

    public String getDate() {
        return this.date;
    }

    public String getPurchaser() {
        return this.purchaser;
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getParsedZonedDate() {
        return this.parsedDate;
    }
}

